/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import net.sourceforge.vrapper.keymap.KeyMap;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SimpleRemapping;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;

public abstract class KeyMapper
implements Evaluator {
    private static final KeyStroke LEADER_KEY = new SimpleKeyStroke(SpecialKey.LEADER);
    final String[] keymaps;

    public KeyMapper(String ... keymaps) {
        this.keymaps = keymaps;
    }

    public static class Clear
    extends KeyMapper {
        public Clear(String ... keymaps) {
            super(keymaps);
        }

        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) {
            String[] stringArray = this.keymaps;
            int n = this.keymaps.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                KeyMap map = vim.getKeyMapProvider().getKeyMap(name);
                map.clear();
                ++n2;
            }
            return null;
        }
    }

    public static class Map
    extends KeyMapper {
        private final boolean recursive;

        public Map(boolean recursive, String ... keymaps) {
            super(keymaps);
            this.recursive = recursive;
        }

        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) {
            String lhs = command.poll();
            String rhs = "";
            while (!command.isEmpty()) {
                rhs = String.valueOf(rhs) + command.poll() + " ";
            }
            if (lhs != null && !"".equals(rhs)) {
                boolean useRecursive = this.recursive;
                if (this.recursive && rhs.startsWith(lhs)) {
                    useRecursive = false;
                    vim.getUserInterfaceService().setInfoMessage("Changing recursive remap '" + lhs + "' to non-recursive.");
                }
                String mapLeader = vim.getConfiguration().get(Options.MAPLEADER);
                ArrayList<KeyStroke> leaderKeys = new ArrayList<KeyStroke>();
                for (KeyStroke keystroke : ConstructorWrappers.parseKeyStrokes(mapLeader)) {
                    leaderKeys.add(keystroke);
                }
                rhs = rhs.trim();
                Iterable<KeyStroke> lhsKeyStrokes = Map.replaceLeader(ConstructorWrappers.parseKeyStrokes(lhs), leaderKeys);
                Iterable<KeyStroke> rhsKeyStrokes = Map.replaceLeader(ConstructorWrappers.parseKeyStrokes(rhs), leaderKeys);
                String[] stringArray = this.keymaps;
                int n = this.keymaps.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    KeyMap map = vim.getKeyMapProvider().getKeyMap(name);
                    map.addMapping(lhsKeyStrokes, new SimpleRemapping(rhsKeyStrokes, useRecursive));
                    ++n2;
                }
            }
            return null;
        }

        protected static Iterable<KeyStroke> replaceLeader(Iterable<KeyStroke> inputKeys, Collection<KeyStroke> leaderKeys) {
            if (!leaderKeys.iterator().hasNext()) {
                return inputKeys;
            }
            ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
            for (KeyStroke keystroke : inputKeys) {
                if (keystroke == null) continue;
                if (keystroke.equals(LEADER_KEY)) {
                    result.addAll(leaderKeys);
                    continue;
                }
                result.add(keystroke);
            }
            return result;
        }
    }

    public static class Unmap
    extends KeyMapper {
        public Unmap(String ... keymaps) {
            super(keymaps);
        }

        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) {
            if (!command.isEmpty()) {
                Iterable<KeyStroke> mapping = ConstructorWrappers.parseKeyStrokes(command.poll());
                String[] stringArray = this.keymaps;
                int n = this.keymaps.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    KeyMap map = vim.getKeyMapProvider().getKeyMap(name);
                    map.removeMapping(mapping);
                    ++n2;
                }
            }
            return null;
        }
    }
}

