/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.Queue;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.BufferDoException;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.LocalConfiguration;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;

public class HighlightSearch {
    public static final String SEARCH_HL_SCOPE_WINDOW = "window";
    public static final String SEARCH_HL_SCOPE_LOCAL = "local";
    public static final String SEARCH_HL_SCOPE_CLEAR = "clear";
    public static final String SEARCH_HL_OPTIONS = "window,local,clear";
    public static final Evaluator CLEAR_HIGHLIGHT = new ClearHighlightingEvaluator();
    public static final Evaluator CLEAR_LOCAL_HIGHLIGHT = new ClearLocalHighlightingEvaluator();
    public static final Evaluator HIGHLIGHT = new HighlightingEvaluator();

    public static class ClearHighlightingEvaluator
    implements Evaluator {
        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
            LocalConfiguration configuration = vim.getConfiguration();
            String hlScope = configuration.get(Options.SEARCH_HL_SCOPE);
            if (hlScope.equalsIgnoreCase(HighlightSearch.SEARCH_HL_SCOPE_CLEAR) || hlScope.equalsIgnoreCase(HighlightSearch.SEARCH_HL_SCOPE_WINDOW)) {
                try {
                    vim.getBufferAndTabService().doInBuffers(false, command, CLEAR_LOCAL_HIGHLIGHT);
                }
                catch (BufferDoException e) {
                    VrapperLog.error("nohlsearch failed", e);
                    throw new CommandExecutionException("nohlsearch failed: " + e.toString());
                }
            } else {
                CLEAR_LOCAL_HIGHLIGHT.evaluate(vim, command);
            }
            return null;
        }
    }

    protected static class ClearLocalHighlightingEvaluator
    implements Evaluator {
        protected ClearLocalHighlightingEvaluator() {
        }

        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
            vim.getSearchAndReplaceService().removeHighlighting();
            return null;
        }
    }

    public static class HighlightingEvaluator
    implements Evaluator {
        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
            LocalConfiguration configuration = vim.getConfiguration();
            String hlScope = configuration.get(Options.SEARCH_HL_SCOPE);
            if (hlScope.equals(HighlightSearch.SEARCH_HL_SCOPE_CLEAR)) {
                this.clearHighlightExceptCurrent(vim, command);
            }
            if (hlScope.equals(HighlightSearch.SEARCH_HL_SCOPE_WINDOW)) {
                try {
                    vim.getBufferAndTabService().doInBuffers(false, command, new Evaluator(){

                        @Override
                        public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
                            Search lastSearch = vim.getRegisterManager().getSearch();
                            vim.getSearchAndReplaceService().highlight(lastSearch);
                            return null;
                        }
                    });
                }
                catch (BufferDoException e) {
                    VrapperLog.error("search highlighting failed", e);
                    throw new CommandExecutionException("search highlighting failed: " + e.toString());
                }
            } else {
                Search lastSearch = vim.getRegisterManager().getSearch();
                vim.getSearchAndReplaceService().highlight(lastSearch);
            }
            return null;
        }

        protected void clearHighlightExceptCurrent(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
            final EditorAdaptor currentEditor = vim;
            try {
                vim.getBufferAndTabService().doInBuffers(false, command, new Evaluator(){

                    @Override
                    public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
                        if (!vim.equals(currentEditor)) {
                            CLEAR_LOCAL_HIGHLIGHT.evaluate(vim, command);
                        }
                        return null;
                    }
                });
            }
            catch (BufferDoException e) {
                VrapperLog.error("nohlsearch failed", e);
                throw new CommandExecutionException("nohlsearch failed: " + e.toString());
            }
        }
    }
}

