/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;

public class FilePathTabCompletion {
    private EditorAdaptor editorAdaptor;
    private String original = null;
    private String lastAttempt = null;
    private int numMatches = 0;

    public FilePathTabCompletion(EditorAdaptor editorAdaptor) {
        this.editorAdaptor = editorAdaptor;
    }

    private void init(String prefix) {
        this.original = prefix;
        this.numMatches = 0;
        this.lastAttempt = null;
    }

    public String getNextMatch(String prefix, boolean searchPath, boolean dirsOnly, boolean reverse) {
        String match;
        if (this.lastAttempt == null || !this.lastAttempt.equals(prefix)) {
            this.init(prefix);
        }
        if (searchPath) {
            String[] paths = this.editorAdaptor.getConfiguration().get(Options.PATH).split(",");
            int i = 0;
            while (i < paths.length) {
                if ("".equals(paths[i])) {
                    paths[i] = this.getStartDir("");
                }
                ++i;
            }
            match = this.editorAdaptor.getFileService().findFileInPath(this.original, this.lastAttempt, reverse, paths);
        } else {
            match = dirsOnly ? this.editorAdaptor.getFileService().getDirPathMatch(this.original, this.lastAttempt, reverse, this.getStartDir(this.original)) : this.editorAdaptor.getFileService().getFilePathMatch(this.original, this.lastAttempt, reverse, this.getStartDir(this.original));
        }
        if (match.equals(this.original)) {
            this.lastAttempt = null;
            if (this.numMatches == 1) {
                this.init(match);
                return this.getNextMatch(prefix, searchPath, dirsOnly, reverse);
            }
        } else {
            this.lastAttempt = match;
            ++this.numMatches;
        }
        return match;
    }

    private String getStartDir(String prefix) {
        if (prefix.startsWith("/")) {
            return "";
        }
        if (this.editorAdaptor.getConfiguration().get(Options.AUTO_CHDIR).booleanValue()) {
            return this.editorAdaptor.getFileService().getCurrentFilePath();
        }
        return this.editorAdaptor.getRegisterManager().getCurrentWorkingDirectory();
    }
}

