/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.UserCommandCommand;
import net.sourceforge.vrapper.vim.modes.commandline.CommandWrapper;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;

public class EvaluatorMapping
implements Evaluator {
    private final Map<String, Evaluator> actions = new HashMap<String, Evaluator>();
    private final Map<String, String> userDefined = new HashMap<String, String>();
    private final Evaluator defaultCase;

    public EvaluatorMapping() {
        this(null);
    }

    public EvaluatorMapping(Evaluator defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
        Evaluator a;
        if (!command.isEmpty() && (a = this.actions.get(command.peek())) != null) {
            command.poll();
            return a.evaluate(vim, command);
        }
        return this.defaultCase != null ? this.defaultCase.evaluate(vim, command) : null;
    }

    public void add(String key, Evaluator evaluator) {
        this.actions.put(key, evaluator);
    }

    public void add(String key, Command action) {
        this.actions.put(key, new CommandWrapper(action));
    }

    public void addUserDefined(String key, String command) {
        this.userDefined.put(key, command);
        this.add(key, new UserCommandCommand(command));
    }

    Evaluator get(String key) {
        return this.actions.get(key);
    }

    public Map<String, String> getUserDefined() {
        return this.userDefined;
    }

    public boolean contains(String key) {
        return this.actions.containsKey(key);
    }

    public Evaluator getDefaultCase() {
        return this.defaultCase;
    }

    public String getNameFromPartial(String partial) {
        if (partial.endsWith("!")) {
            partial = partial.substring(0, partial.length() - 1);
        }
        String commandName = null;
        for (String name : this.actions.keySet()) {
            if (!name.startsWith(partial)) continue;
            if (commandName == null) {
                commandName = name;
                continue;
            }
            return null;
        }
        return commandName;
    }

    public void addAll(EvaluatorMapping other) {
        for (Map.Entry<String, Evaluator> entry : other.actions.entrySet()) {
            if (this.actions.containsKey(entry.getKey())) continue;
            this.actions.put(entry.getKey(), entry.getValue());
        }
    }
}

