/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;

public class ComplexOptionEvaluator
implements Evaluator {
    @Override
    public Object evaluate(EditorAdaptor vim, Queue<String> command) {
        String next = command.poll();
        int index = next.indexOf(61);
        if (index < 0) {
            this.noSuchOptionMessage(vim, next);
            return null;
        }
        String optName = next.substring(0, index).trim();
        boolean additive = false;
        boolean subtractive = false;
        if (optName.endsWith("+")) {
            additive = true;
            optName = optName.substring(0, optName.length() - 1);
        } else if (optName.endsWith("-")) {
            subtractive = true;
            optName = optName.substring(0, optName.length() - 1);
        }
        String value = next.substring(index + 1);
        if (command.size() > 0) {
            value = String.valueOf(value) + " " + StringUtils.join(" ", command);
        }
        try {
            Configuration.Option strOpt = this.find(Options.STRING_OPTIONS, optName);
            if (strOpt != null) {
                if (additive) {
                    String newValue = String.valueOf((String)vim.getConfiguration().get(strOpt)) + value;
                    this.validate(strOpt, newValue);
                    this.set(vim, strOpt, newValue);
                } else if (subtractive) {
                    String newValue = ((String)vim.getConfiguration().get(strOpt)).replace(value, "");
                    this.validate(strOpt, newValue);
                    this.set(vim, strOpt, newValue);
                } else {
                    this.validate(strOpt, value);
                    this.set(vim, strOpt, value);
                }
            } else {
                Configuration.Option<Set<String>> stringSetOpt = this.find(Options.STRINGSET_OPTIONS, optName);
                if (stringSetOpt != null) {
                    HashSet<String> newValue = new HashSet<String>();
                    if (value.trim().length() > 0) {
                        String[] values = value.split(",");
                        newValue.addAll(Arrays.asList(values));
                        this.validateSet(stringSetOpt, newValue);
                    }
                    this.set(vim, stringSetOpt, newValue);
                } else {
                    Configuration.Option intOpt = this.find(Options.INT_OPTIONS, optName);
                    if (intOpt != null) {
                        this.validate(intOpt, Integer.valueOf(value));
                        this.set(vim, intOpt, Integer.valueOf(value));
                    } else {
                        Configuration.Option boolOpt = this.find(Options.BOOLEAN_OPTIONS, optName);
                        if (boolOpt != null) {
                            this.validate(boolOpt, Boolean.valueOf(value));
                            this.set(vim, boolOpt, Boolean.valueOf(value));
                        } else {
                            this.noSuchOptionMessage(vim, optName);
                        }
                    }
                }
            }
        }
        catch (ValueException valueException) {
            this.invalidValueMessage(vim, value);
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidValueMessage(vim, value);
        }
        return null;
    }

    private void invalidValueMessage(EditorAdaptor vim, String value) {
        vim.getUserInterfaceService().setErrorMessage("Invalid value: " + value);
    }

    private void noSuchOptionMessage(EditorAdaptor vim, String name) {
        vim.getUserInterfaceService().setErrorMessage("Unknown option: " + name);
    }

    protected <T> void validate(Configuration.Option<T> opt, T value) throws ValueException {
        if (opt.getLegalValues() != null && !opt.getLegalValues().contains(value)) {
            throw new ValueException();
        }
    }

    protected void validateSet(Configuration.Option<Set<String>> opt, Set<String> values) throws ValueException {
        HashSet<String> cleanedValues = new HashSet<String>();
        for (String value : values) {
            int valueDelimIndex = value.indexOf(":");
            if (valueDelimIndex != -1) {
                cleanedValues.add(value.substring(0, valueDelimIndex + 1));
                continue;
            }
            cleanedValues.add(value);
        }
        if (opt.getLegalValues() == null || !opt.getLegalValues().containsAll(cleanedValues)) {
            throw new ValueException();
        }
    }

    protected <T> void set(EditorAdaptor adaptor, Configuration.Option<T> opt, T value) throws ValueException {
        adaptor.getConfiguration().set(opt, value);
    }

    private <T> Configuration.Option<T> find(Set<Configuration.Option<T>> options, String optName) {
        for (Configuration.Option<T> o : options) {
            for (String name : o.getAllNames()) {
                if (!name.equals(optName)) continue;
                return o;
            }
        }
        return null;
    }

    class ValueException
    extends Exception {
        ValueException() {
        }
    }
}

