/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.modes.commandline.AbstractCommandLineMode;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineParser;
import net.sourceforge.vrapper.vim.modes.commandline.EvaluatorMapping;

public class CommandLineMode
extends AbstractCommandLineMode {
    private static EvaluatorMapping coreCommands = CommandLineParser.coreCommands();
    public static final String DISPLAY_NAME = "COMMAND LINE";
    public static final String NAME = "command mode";
    private EvaluatorMapping commands = new EvaluatorMapping();

    public CommandLineMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
        this.commands.addAll(coreCommands);
    }

    @Override
    public CommandLineParser createParser() {
        return new CommandLineParser(this.editorAdaptor, this.commands);
    }

    @Override
    protected String getPrompt() {
        return ":";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return "Command Mode Keymap";
    }

    public boolean addCommand(String commandName, Command command, boolean overwrite) {
        if (overwrite || !this.commands.contains(commandName)) {
            this.commands.add(commandName, command);
            return true;
        }
        return false;
    }
}

