/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.EnumSet;
import java.util.HashMap;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Utils;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineHistory;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterManager;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public abstract class AbstractCommandParser {
    protected static final KeyStroke KEY_RETURN = ConstructorWrappers.key(SpecialKey.RETURN);
    protected static final KeyStroke KEY_ESCAPE = ConstructorWrappers.key(SpecialKey.ESC);
    protected static final KeyStroke KEY_CTRL_W = ConstructorWrappers.ctrlKey('w');
    protected static final KeyStroke KEY_CTRL_R = ConstructorWrappers.ctrlKey('r');
    protected static final KeyStroke KEY_CTRL_A = ConstructorWrappers.ctrlKey('a');
    protected static final KeyStroke KEY_CTRL_U = ConstructorWrappers.ctrlKey('u');
    protected static final KeyStroke KEY_CTRL_V = ConstructorWrappers.ctrlKey('v');
    protected static final KeyStroke KEY_CTRL_Y = ConstructorWrappers.ctrlKey('y');
    protected static final KeyStroke KEY_BACKSP = ConstructorWrappers.key(SpecialKey.BACKSPACE);
    protected static final KeyStroke KEY_DELETE = ConstructorWrappers.key(SpecialKey.DELETE);
    protected static final KeyStroke KEY_UP = ConstructorWrappers.key(SpecialKey.ARROW_UP);
    protected static final KeyStroke KEY_DOWN = ConstructorWrappers.key(SpecialKey.ARROW_DOWN);
    protected static final KeyStroke KEY_RIGHT = ConstructorWrappers.key(SpecialKey.ARROW_RIGHT);
    protected static final KeyStroke KEY_LEFT = ConstructorWrappers.key(SpecialKey.ARROW_LEFT);
    protected static final KeyStroke KEY_HOME = ConstructorWrappers.key(SpecialKey.HOME);
    protected static final KeyStroke KEY_END = ConstructorWrappers.key(SpecialKey.END);
    protected static final KeyStroke KEY_CTRL_INS = new SimpleKeyStroke(SpecialKey.INSERT, EnumSet.of(KeyStroke.Modifier.CONTROL));
    protected static final KeyStroke KEY_SHFT_INS = new SimpleKeyStroke(SpecialKey.INSERT, EnumSet.of(KeyStroke.Modifier.SHIFT));
    protected static final KeyStroke KEY_CMD_C = new SimpleKeyStroke('c', EnumSet.of(KeyStroke.Modifier.COMMAND));
    protected static final KeyStroke KEY_CMD_V = new SimpleKeyStroke('v', EnumSet.of(KeyStroke.Modifier.COMMAND));
    protected static final KeyStroke KEY_CMD_X = new SimpleKeyStroke('x', EnumSet.of(KeyStroke.Modifier.COMMAND));
    protected final EditorAdaptor editor;
    private boolean pasteRegister = false;
    protected CommandLineUI commandLine;
    private final CommandLineHistory history = CommandLineHistory.INSTANCE;
    private boolean modified;
    private boolean isFromVisual = false;
    private boolean isCommandLineHistoryEnabled = true;
    private HashMap<KeyStroke, KeyHandler> editMap = new HashMap();

    public AbstractCommandParser(EditorAdaptor vim) {
        this.editMap.put(KEY_UP, new KeyHandler(){

            @Override
            public void handleKey() {
                if (AbstractCommandParser.this.modified) {
                    AbstractCommandParser.this.history.setTemp(AbstractCommandParser.this.commandLine.getContents());
                }
                String previous = AbstractCommandParser.this.history.getPrevious();
                AbstractCommandParser.this.setCommandFromHistory(previous);
            }
        });
        this.editMap.put(KEY_DOWN, new KeyHandler(){

            @Override
            public void handleKey() {
                if (AbstractCommandParser.this.modified) {
                    AbstractCommandParser.this.history.setTemp(AbstractCommandParser.this.commandLine.getContents());
                }
                String next = AbstractCommandParser.this.history.getNext();
                AbstractCommandParser.this.setCommandFromHistory(next);
            }
        });
        this.editMap.put(KEY_LEFT, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.addOffsetToPosition(-1);
            }
        });
        this.editMap.put(KEY_RIGHT, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.addOffsetToPosition(1);
            }
        });
        this.editMap.put(KEY_DELETE, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.delete();
                AbstractCommandParser.this.modified = true;
            }
        });
        this.editMap.put(KEY_CTRL_R, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.setMode(CommandLineUI.CommandLineMode.REGISTER);
                AbstractCommandParser.this.pasteRegister = true;
                AbstractCommandParser.this.modified = true;
            }
        });
        this.editMap.put(KEY_HOME, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.setPosition(0);
            }
        });
        this.editMap.put(KEY_END, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.setPosition(AbstractCommandParser.this.commandLine.getEndPosition());
            }
        });
        this.editMap.put(KEY_CTRL_W, new KeyHandler(){

            @Override
            public void handleKey() {
                if (AbstractCommandParser.this.pasteRegister) {
                    String word = VimUtils.getWordUnderCursor(AbstractCommandParser.this.editor, false);
                    AbstractCommandParser.this.commandLine.type(word);
                } else {
                    AbstractCommandParser.this.deleteWordBack();
                }
            }
        });
        this.editMap.put(KEY_CTRL_A, new KeyHandler(){

            @Override
            public void handleKey() {
                if (AbstractCommandParser.this.pasteRegister) {
                    String word = VimUtils.getWordUnderCursor(AbstractCommandParser.this.editor, true);
                    AbstractCommandParser.this.commandLine.type(word);
                }
            }
        });
        this.editMap.put(KEY_CTRL_U, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.commandLine.replace(0, AbstractCommandParser.this.commandLine.getPosition(), "");
                AbstractCommandParser.this.commandLine.setPosition(0);
                AbstractCommandParser.this.modified = true;
            }
        });
        this.editMap.put(KEY_CTRL_Y, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.copySelectionToClipboard();
            }
        });
        this.editMap.put(KEY_CMD_C, this.editMap.get(KEY_CTRL_Y));
        this.editMap.put(KEY_CTRL_INS, this.editMap.get(KEY_CTRL_Y));
        this.editMap.put(KEY_CTRL_V, new KeyHandler(){

            @Override
            public void handleKey() {
                AbstractCommandParser.this.pasteRegister("+");
            }
        });
        this.editMap.put(KEY_SHFT_INS, this.editMap.get(KEY_CTRL_V));
        this.editMap.put(KEY_CMD_V, this.editMap.get(KEY_CTRL_V));
        this.editMap.put(KEY_CMD_X, new KeyHandler(){

            @Override
            public void handleKey() {
                if (AbstractCommandParser.this.commandLine.getSelectionLength() > 0) {
                    AbstractCommandParser.this.copySelectionToClipboard();
                    AbstractCommandParser.this.commandLine.delete();
                }
            }
        });
        this.editor = vim;
        this.modified = false;
        this.history.setMode(this.editor.getCurrentModeName());
    }

    public void type(KeyStroke e) {
        Command c = null;
        KeyHandler mappedHandler = this.editMap.get(e);
        if (mappedHandler != null) {
            mappedHandler.handleKey();
        } else if (e.equals(KEY_RETURN)) {
            if (this.isHistoryEnabled() && e.isVirtual()) {
                this.setHistoryEnabled(false);
            }
            c = this.parseAndExecute();
        } else {
            if (e.getSpecialKey() == SpecialKey.TAB) {
                String completed = this.completeArgument(this.commandLine.getContents(), e);
                if (completed != null) {
                    this.commandLine.resetContents(completed);
                }
                this.pasteRegister = false;
                return;
            }
            if (e.getCharacter() != '\u0000' && this.pasteRegister) {
                String registerName = Character.toString(e.getCharacter());
                this.pasteRegister(registerName);
                this.pasteRegister = false;
                this.modified = true;
            } else if (e.getCharacter() != '\u0000') {
                this.commandLine.type(Character.toString(e.getCharacter()));
                this.modified = true;
            }
        }
        if (this.pasteRegister && e.equals(KEY_ESCAPE)) {
            this.pasteRegister = false;
            this.commandLine.setMode(CommandLineUI.CommandLineMode.DEFAULT);
        } else if (this.pasteRegister && !e.equals(KEY_CTRL_R)) {
            this.pasteRegister = false;
            this.commandLine.setMode(CommandLineUI.CommandLineMode.DEFAULT);
        } else if (e.equals(KEY_BACKSP)) {
            if (this.commandLine.getContents().length() == 0) {
                this.handleExit(null);
            } else {
                this.commandLine.erase();
            }
            this.modified = true;
        } else if (e.equals(KEY_RETURN) || e.equals(KEY_ESCAPE)) {
            this.handleExit(c);
        } else if (!this.pasteRegister) {
            this.commandLine.setMode(CommandLineUI.CommandLineMode.DEFAULT);
        }
    }

    private void pasteRegister(String registerName) {
        String text = this.editor.getRegisterManager().getRegister(registerName).getContent().getText();
        text = VimUtils.stripLastNewline(text);
        text = VimUtils.replaceNewLines(text, " ");
        this.commandLine.type(text);
    }

    private void copySelectionToClipboard() {
        if (this.commandLine.getSelectionLength() > 0) {
            RegisterManager regMan = this.editor.getRegisterManager();
            Register clipboard = regMan.getRegister("+");
            String selected = this.commandLine.getContents(this.commandLine.getSelectionStart(), this.commandLine.getSelectionEnd());
            clipboard.setContent(new StringRegisterContent(ContentType.TEXT, selected));
        }
    }

    protected String completeArgument(String commandLineContents, KeyStroke e) {
        return null;
    }

    private void setCommandFromHistory(String cmd) {
        if (cmd == null) {
            return;
        }
        this.modified = false;
        this.commandLine.resetContents(cmd);
    }

    private void deleteWordBack() {
        int offset = this.commandLine.getPosition();
        if (offset <= 1) {
            offset = 0;
        } else {
            String contents = this.commandLine.getContents();
            if (offset > contents.length()) {
                offset = contents.length();
            }
            String iskeyword = this.editor.getConfiguration().get(Options.KEYWORDS);
            while (--offset > 0) {
                char c1 = contents.charAt(offset - 1);
                char c2 = contents.charAt(offset);
                if (Character.isWhitespace(c2) || Utils.characterType(c1, iskeyword) == Utils.characterType(c2, iskeyword)) continue;
            }
        }
        this.commandLine.replace(offset, this.commandLine.getPosition(), "");
        this.commandLine.setPosition(offset);
    }

    public boolean isHistoryEnabled() {
        return this.isCommandLineHistoryEnabled;
    }

    public void setHistoryEnabled(boolean isCommandLineHistoryEnabled) {
        this.isCommandLineHistoryEnabled = isCommandLineHistoryEnabled;
    }

    public abstract Command parseAndExecute(String var1, String var2);

    protected void handleExit(Command parsedCommand) {
        if (parsedCommand == null && this.isFromVisual) {
            this.editor.changeModeSafely("normal mode", new ExecuteCommandHint.OnEnter(LeaveVisualModeCommand.INSTANCE));
        } else if (parsedCommand == null) {
            this.editor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
        } else {
            this.editor.changeModeSafely(this.isFromVisual ? "normal mode" : this.editor.getLastModeName(), new ExecuteCommandHint.OnEnter(parsedCommand));
            this.editor.setSelection(null);
        }
    }

    private Command parseAndExecute() {
        String first = this.commandLine.getPrompt();
        String c = this.commandLine.getContents();
        if (this.isHistoryEnabled()) {
            this.history.append(c);
            this.setHistoryEnabled(false);
        }
        return this.parseAndExecute(first, c);
    }

    public boolean isFromVisual() {
        return this.isFromVisual;
    }

    public void setFromVisual(boolean isFromVisual) {
        this.isFromVisual = isFromVisual;
    }

    public void setCommandLine(CommandLineUI commandLine) {
        this.commandLine = commandLine;
        this.history.setTemp(commandLine.getContents());
    }

    private static interface KeyHandler {
        public void handleKey();
    }
}

