/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.KeyMapInfo;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.CountConsumingKeyMapState;
import net.sourceforge.vrapper.keymap.vim.CountingState;
import net.sourceforge.vrapper.keymap.vim.GoThereState;
import net.sourceforge.vrapper.keymap.vim.RegisterState;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.AsciiCommand;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CenterLineCommand;
import net.sourceforge.vrapper.vim.commands.ChangeOperation;
import net.sourceforge.vrapper.vim.commands.ChangeToCommandLineCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToInsertModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToSearchModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.CloseCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CommandWrappers;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.DotCommand;
import net.sourceforge.vrapper.vim.commands.FindFileCommand;
import net.sourceforge.vrapper.vim.commands.FormatOperation;
import net.sourceforge.vrapper.vim.commands.IncrementDecrementCommand;
import net.sourceforge.vrapper.vim.commands.InsertAndEditLineCommand;
import net.sourceforge.vrapper.vim.commands.InsertShiftWidth;
import net.sourceforge.vrapper.vim.commands.JoinLinesCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.MotionTextObject;
import net.sourceforge.vrapper.vim.commands.NormalLineRangeOperation;
import net.sourceforge.vrapper.vim.commands.PasteAfterCommand;
import net.sourceforge.vrapper.vim.commands.PasteBeforeCommand;
import net.sourceforge.vrapper.vim.commands.PlaybackMacroCommand;
import net.sourceforge.vrapper.vim.commands.PrintOffsetInformation;
import net.sourceforge.vrapper.vim.commands.RecordMacroMode;
import net.sourceforge.vrapper.vim.commands.RedoCommand;
import net.sourceforge.vrapper.vim.commands.RepeatLastSubstitutionCommand;
import net.sourceforge.vrapper.vim.commands.ReplaceCommand;
import net.sourceforge.vrapper.vim.commands.RestoreSelectionCommand;
import net.sourceforge.vrapper.vim.commands.SaveCommand;
import net.sourceforge.vrapper.vim.commands.SelectTextObjectCommand;
import net.sourceforge.vrapper.vim.commands.SetMarkCommand;
import net.sourceforge.vrapper.vim.commands.SwapCaseCommand;
import net.sourceforge.vrapper.vim.commands.SwitchBufferCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperationTextObjectCommand;
import net.sourceforge.vrapper.vim.commands.UndoCommand;
import net.sourceforge.vrapper.vim.commands.VimCommandSequence;
import net.sourceforge.vrapper.vim.commands.YankOperation;
import net.sourceforge.vrapper.vim.commands.motions.GoToMarkMotion;
import net.sourceforge.vrapper.vim.commands.motions.LineEndMotion;
import net.sourceforge.vrapper.vim.commands.motions.LineStartMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveBigWORDEndRightForChange;
import net.sourceforge.vrapper.vim.commands.motions.MoveDown;
import net.sourceforge.vrapper.vim.commands.motions.MoveLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveUp;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordEndRightForChange;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.CommandBasedMode;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.KeyMapResolver;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.RegisterKeymapState;
import net.sourceforge.vrapper.vim.modes.ReplaceMode;

public class NormalMode
extends CommandBasedMode {
    public static final String KEYMAP_NAME = "Normal Mode Keymap";
    public static final String NAME = "normal mode";
    public static final String DISPLAY_NAME = "NORMAL";

    public NormalMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    protected KeyMapResolver buildKeyMapResolver() {
        State<KeyMapInfo> state = StateUtils.union(ConstructorWrappers.state(ConstructorWrappers.operatorKeyMap('c'), ConstructorWrappers.operatorKeyMap('d'), ConstructorWrappers.operatorKeyMap('y'), ConstructorWrappers.operatorKeyMap('!'), ConstructorWrappers.operatorKeyMap('<'), ConstructorWrappers.operatorKeyMap('>'), ConstructorWrappers.transitionBind('g', ConstructorWrappers.operatorKeyMap('q'), ConstructorWrappers.operatorKeyMap('~'))), this.editorAdaptor.getPlatformSpecificStateProvider().getKeyMaps(NAME));
        CountConsumingKeyMapState countEater = new CountConsumingKeyMapState(KEYMAP_NAME, "innercount", state);
        RegisterKeymapState registerKeymapState = new RegisterKeymapState(KEYMAP_NAME, countEater);
        CountConsumingKeyMapState outerCountEater = new CountConsumingKeyMapState(KEYMAP_NAME, "outercount", registerKeymapState);
        return new KeyMapResolver(outerCountEater, KEYMAP_NAME);
    }

    @Override
    protected State<Command> buildInitialState() {
        ChangeToInsertModeCommand resumeInsertMode = new ChangeToInsertModeCommand(new MotionCommand(new GoToMarkMotion(false, "^")));
        ChangeToVisualModeCommand visualMode = new ChangeToVisualModeCommand("visual mode");
        ChangeToVisualModeCommand linewiseVisualMode = new ChangeToVisualModeCommand("linewise visual mode");
        ChangeToVisualModeCommand blockwiseVisualMode = new ChangeToVisualModeCommand("block visual mode");
        Motion moveLeft = MoveLeft.INSTANCE;
        Motion moveRight = MoveRight.INSTANCE;
        MoveWordEndRightForChange wordEndRightForChange = MoveWordEndRightForChange.INSTANCE;
        MoveBigWORDEndRightForChange bigWordEndRightForChange = MoveBigWORDEndRightForChange.INSTANCE;
        LineStartMotion col0 = LineStartMotion.COLUMN0;
        LineStartMotion bol = LineStartMotion.NON_WHITESPACE;
        LineEndMotion eol = new LineEndMotion(BorderPolicy.EXCLUSIVE);
        LineEndMotion wholeLineEol = new LineEndMotion(BorderPolicy.LINE_WISE);
        State<Motion> motions = NormalMode.motions();
        MotionTextObject wordForCw = new MotionTextObject(wordEndRightForChange);
        MotionTextObject wordForCW = new MotionTextObject(bigWordEndRightForChange);
        MotionTextObject toEol = new MotionTextObject(eol);
        MotionTextObject toEolForY = new MotionTextObject(wholeLineEol);
        State<TextObject> textObjects = this.editorAdaptor.getTextObjectProvider().textObjects();
        State<TextObject> textObjectsForChange = StateUtils.union(ConstructorWrappers.state(ConstructorWrappers.leafBind('w', wordForCw), ConstructorWrappers.leafBind('W', wordForCW)), textObjects);
        textObjectsForChange = CountingState.wrap(textObjectsForChange);
        DeleteOperation delete = DeleteOperation.INSTANCE;
        ChangeOperation change = ChangeOperation.INSTANCE;
        YankOperation yank = YankOperation.INSTANCE;
        FormatOperation format = FormatOperation.INSTANCE;
        UndoCommand undo = UndoCommand.INSTANCE;
        Command printOffsetInfo = PrintOffsetInformation.INSTANCE;
        RedoCommand redo = RedoCommand.INSTANCE;
        PasteAfterCommand pasteAfter = PasteAfterCommand.CURSOR_ON_TEXT;
        PasteBeforeCommand pasteBefore = PasteBeforeCommand.CURSOR_ON_TEXT;
        PasteAfterCommand pasteAfterWithG = PasteAfterCommand.CURSOR_AFTER_TEXT;
        PasteBeforeCommand pasteBeforeWithG = PasteBeforeCommand.CURSOR_AFTER_TEXT;
        TextOperationTextObjectCommand deleteNext = new TextOperationTextObjectCommand(delete, new MotionTextObject(moveRight));
        TextOperationTextObjectCommand deletePrevious = new TextOperationTextObjectCommand(delete, new MotionTextObject(moveLeft));
        DotCommand repeatLastOne = DotCommand.INSTANCE;
        SwapCaseCommand tildeCmd = SwapCaseCommand.INSTANCE;
        LineEndMotion lineEndMotion = new LineEndMotion(BorderPolicy.LINE_WISE);
        TextOperationTextObjectCommand substituteLine = new TextOperationTextObjectCommand(change, new MotionTextObject(lineEndMotion));
        TextOperationTextObjectCommand substituteChar = new TextOperationTextObjectCommand(change, new MotionTextObject(moveRight));
        IncrementDecrementCommand incrementNum = IncrementDecrementCommand.INCREMENT;
        IncrementDecrementCommand decrementNum = IncrementDecrementCommand.DECREMENT;
        Command joinLines = JoinLinesCommand.INSTANCE;
        Command joinLinesDumbWay = JoinLinesCommand.DUMB_INSTANCE;
        CenterLineCommand centerLine = CenterLineCommand.CENTER;
        CenterLineCommand centerBottomLine = CenterLineCommand.BOTTOM;
        CenterLineCommand centerTopLine = CenterLineCommand.TOP;
        FindFileCommand findFile = FindFileCommand.INSTANCE;
        RepeatLastSubstitutionCommand repeatSubLine = RepeatLastSubstitutionCommand.CURRENT_LINE_ONLY;
        RepeatLastSubstitutionCommand repeatSubGlobal = RepeatLastSubstitutionCommand.GLOBALLY;
        VimCommandSequence saveAndClose = new VimCommandSequence(SaveCommand.INSTANCE, CloseCommand.CLOSE);
        GoThereState motionCommands = new GoThereState(motions);
        Command nextResult = (Command)motionCommands.press(ConstructorWrappers.key('n')).getValue();
        SelectTextObjectCommand nextSearchResultVisual = new SelectTextObjectCommand(SearchResultMotion.SELECT_NEXT_MATCH);
        SelectTextObjectCommand prevSearchResultVisual = new SelectTextObjectCommand(SearchResultMotion.SELECT_PREVIOUS_MATCH);
        State<Command> platformSpecificState = this.getPlatformSpecificState(NAME);
        return CountingState.wrap(RegisterState.wrap(CountingState.wrap(StateUtils.union(platformSpecificState, ConstructorWrappers.operatorCmdsWithUpperCase('d', delete, toEol, textObjects), ConstructorWrappers.operatorCmdsWithUpperCase('y', yank, toEolForY, textObjects), ConstructorWrappers.operatorCmdsWithUpperCase('c', change, toEol, textObjectsForChange), ConstructorWrappers.operatorCmds('!', NormalLineRangeOperation.INSTANCE, textObjects), ConstructorWrappers.operatorCmds('>', InsertShiftWidth.INSERT, textObjects), ConstructorWrappers.operatorCmds('<', InsertShiftWidth.REMOVE, textObjects), ConstructorWrappers.prefixedOperatorCmds('g', 'q', format, textObjects), ConstructorWrappers.prefixedOperatorCmds('g', '~', SwapCaseCommand.TEXT_OBJECT_INSTANCE, textObjects), motionCommands, ConstructorWrappers.state(ConstructorWrappers.leafBind('i', new ChangeToInsertModeCommand()), ConstructorWrappers.leafBind('a', new ChangeToInsertModeCommand(new MotionCommand(moveRight))), ConstructorWrappers.leafBind('I', new ChangeToInsertModeCommand(new MotionCommand(bol))), ConstructorWrappers.leafBind('A', new ChangeToInsertModeCommand(new MotionCommand(eol))), ConstructorWrappers.leafBind(':', ChangeToCommandLineCommand.INSTANCE), ConstructorWrappers.leafBind('?', new ChangeToSearchModeCommand(true, nextResult)), ConstructorWrappers.leafBind('/', new ChangeToSearchModeCommand(false, nextResult)), ConstructorWrappers.leafBind('R', new ReplaceMode.ChangeToReplaceModeCommand()), ConstructorWrappers.leafBind('o', InsertAndEditLineCommand.POST_CURSOR), ConstructorWrappers.leafBind('O', InsertAndEditLineCommand.PRE_CURSOR), ConstructorWrappers.leafBind('v', visualMode), ConstructorWrappers.leafBind('V', linewiseVisualMode), ConstructorWrappers.leafCtrlBind('v', blockwiseVisualMode), ConstructorWrappers.leafCtrlBind('q', blockwiseVisualMode), ConstructorWrappers.leafBind('p', pasteAfter), ConstructorWrappers.leafBind('.', repeatLastOne), ConstructorWrappers.leafBind('P', pasteBefore), ConstructorWrappers.leafBind('x', deleteNext), ConstructorWrappers.leafBind(SpecialKey.DELETE, deleteNext), ConstructorWrappers.leafBind('X', deletePrevious), ConstructorWrappers.leafBind('~', tildeCmd), ConstructorWrappers.leafBind('S', substituteLine), ConstructorWrappers.leafBind('s', substituteChar), ConstructorWrappers.leafBind('J', joinLines), ConstructorWrappers.leafCtrlBind('6', SwitchBufferCommand.INSTANCE), ConstructorWrappers.leafCtrlBind('^', SwitchBufferCommand.INSTANCE), ConstructorWrappers.leafBind('&', repeatSubLine), ConstructorWrappers.transitionBind('g', ConstructorWrappers.leafCtrlBind('g', printOffsetInfo), ConstructorWrappers.leafBind('a', AsciiCommand.INSTANCE), ConstructorWrappers.leafBind('f', findFile), ConstructorWrappers.leafBind('&', repeatSubGlobal), ConstructorWrappers.leafBind('i', resumeInsertMode), ConstructorWrappers.leafBind('I', new ChangeToInsertModeCommand(new MotionCommand(col0))), ConstructorWrappers.leafBind('J', joinLinesDumbWay), ConstructorWrappers.leafBind('n', nextSearchResultVisual), ConstructorWrappers.leafBind('N', prevSearchResultVisual), ConstructorWrappers.leafBind('p', pasteAfterWithG), ConstructorWrappers.leafBind('P', pasteBeforeWithG), ConstructorWrappers.leafBind('v', RestoreSelectionCommand.INSTANCE)), ConstructorWrappers.leafBind('q', RecordMacroMode.TOGGLE_MACRO_RECORDING), ConstructorWrappers.transitionBind('@', ConstructorWrappers.convertKeyStroke(PlaybackMacroCommand.KEYSTROKE_CONVERTER, VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('r', ConstructorWrappers.changeCaret(CaretType.UNDERLINE), ConstructorWrappers.convertKeyStroke(ReplaceCommand.KEYSTROKE_CONVERTER, VimConstants.PRINTABLE_KEYSTROKES_WITH_NL)), ConstructorWrappers.transitionBind('m', ConstructorWrappers.convertKeyStroke(SetMarkCommand.KEYSTROKE_CONVERTER, VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.leafBind('u', undo), ConstructorWrappers.leafCtrlBind('r', redo), ConstructorWrappers.transitionBind(ConstructorWrappers.ctrlKey('w'), ConstructorWrappers.leafBind('q', CloseCommand.CLOSE)), ConstructorWrappers.leafCtrlBind('a', incrementNum), ConstructorWrappers.leafCtrlBind('x', decrementNum), ConstructorWrappers.transitionBind('Z', ConstructorWrappers.leafBind('Z', saveAndClose), ConstructorWrappers.leafBind('Q', CloseCommand.FORCED_CLOSE)), ConstructorWrappers.transitionBind('z', ConstructorWrappers.leafBind('z', centerLine), ConstructorWrappers.leafBind('.', centerLine), ConstructorWrappers.leafBind('-', centerBottomLine), ConstructorWrappers.leafBind('b', centerBottomLine), ConstructorWrappers.leafBind('t', centerTopLine), ConstructorWrappers.leafBind(SpecialKey.RETURN, centerTopLine)), ConstructorWrappers.leafBind(ConstructorWrappers.shiftKey(SpecialKey.ARROW_LEFT), CommandWrappers.cmd(new ChangeToVisualModeCommand("visual mode", MoveLeft.INSTANCE))), ConstructorWrappers.leafBind(ConstructorWrappers.shiftKey(SpecialKey.ARROW_RIGHT), CommandWrappers.cmd(new ChangeToVisualModeCommand("visual mode", MoveRight.INSTANCE))), ConstructorWrappers.leafBind(ConstructorWrappers.shiftKey(SpecialKey.ARROW_UP), CommandWrappers.cmd(new ChangeToVisualModeCommand("visual mode", MoveUp.INSTANCE))), ConstructorWrappers.leafBind(ConstructorWrappers.shiftKey(SpecialKey.ARROW_DOWN), CommandWrappers.cmd(new ChangeToVisualModeCommand("visual mode", MoveDown.INSTANCE))))))));
    }

    @Override
    public void placeCursor(StickyColumnPolicy stickyColumnPolicy) {
        if (this.isEnabled) {
            int selectionLength = this.editorAdaptor.getNativeSelection().getViewLength();
            Position pos = this.editorAdaptor.getPosition();
            int offset = pos.getViewOffset();
            LineInformation line = this.editorAdaptor.getViewContent().getLineInformationOfOffset(offset);
            if (this.currentState == this.initialState) {
                if (selectionLength == 0) {
                    this.editorAdaptor.getCursorService().setCaret(CaretType.RECTANGULAR);
                } else {
                    this.editorAdaptor.getCursorService().setCaret(CaretType.OVERLINE);
                }
            }
            if (line.getEndOffset() == offset && line.getLength() > 0 && selectionLength <= 0) {
                this.editorAdaptor.setPosition(pos.addViewOffset(-1), stickyColumnPolicy);
            }
        }
    }

    @Override
    protected void commandDone() {
        super.commandDone();
        this.editorAdaptor.getRegisterManager().activateDefaultRegister();
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        this.editorAdaptor.getCursorService().setCaret(CaretType.RECTANGULAR);
        super.enterMode(args);
        ExecuteCommandHint hint = VimUtils.findModeHint(ExecuteCommandHint.OnEnter.class, args);
        if (hint != null) {
            try {
                this.executeCommand(hint.getCommand());
            }
            catch (CommandExecutionException e) {
                this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
        }
        this.placeCursor(StickyColumnPolicy.NEVER);
        this.editorAdaptor.getRegisterManager().activateDefaultRegister();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

