/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class ContentAssistMode
extends InsertMode {
    public static final String KEYMAP_NAME = "Content Assist Mode Keymap";
    public static final String NAME = "content assist";
    public static final String DISPLAY_NAME = "CONTENT-ASSIST";
    protected State<Command> currentState = this.buildState();

    public ContentAssistMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        super.enterMode(InsertMode.RESUME_ON_MODE_ENTER, InsertMode.DONT_LOCK_HISTORY);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) {
        super.leaveMode(InsertMode.RESUME_ON_MODE_ENTER, InsertMode.DONT_MOVE_CURSOR);
    }

    @Override
    public boolean handleKey(KeyStroke keyStroke) {
        Transition<Command> transition = this.currentState.press(keyStroke);
        boolean commandRecognized = false;
        if (transition != null && transition.getValue() != null) {
            commandRecognized = true;
            try {
                this.editorAdaptor.getListeners().fireCommandAboutToExecute();
                transition.getValue().execute(this.editorAdaptor);
                this.editorAdaptor.getListeners().fireCommandExecuted();
                return true;
            }
            catch (CommandExecutionException e) {
                this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
        }
        this.editorAdaptor.getListeners().fireStateReset(commandRecognized);
        return super.handleKey(keyStroke);
    }

    @Override
    protected State<Command> buildState() {
        State<Command> platformSpecificState = this.editorAdaptor.getPlatformSpecificStateProvider().getState(NAME);
        if (platformSpecificState == null) {
            platformSpecificState = EmptyState.getInstance();
        }
        return platformSpecificState;
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return KEYMAP_NAME;
    }
}

