/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchOffset;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.utils.SubstitutionDefinition;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CenterLineCommand;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class ConfirmSubstitutionMode
extends AbstractMode {
    public static final String NAME = "confirm substitution mode";
    public static final String DISPLAY_NAME = "CONFIRM SUBSTITUTION";
    private static final KeyStroke KEY_ESCAPE = ConstructorWrappers.key(SpecialKey.ESC);
    private SubstitutionDefinition subDef;
    private int endOffset;
    private int nextLine;
    private int totalLength;
    private int replaceOffset = 0;
    private boolean globalFlag = false;
    private boolean caseSensitive = false;
    private boolean useRegex = true;
    private CommandLineUI commandLine;
    private SearchResult lastMatch;

    public ConfirmSubstitutionMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void enterMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.enterMode(new ModeSwitchHint[0]);
        if (hints.length > 0 && hints[0] instanceof SubstitutionConfirm) {
            SubstitutionConfirm hint = (SubstitutionConfirm)hints[0];
            this.subDef = hint.subDef;
            this.globalFlag = this.subDef.flags.contains("g");
            this.caseSensitive = this.editorAdaptor.getSearchAndReplaceService().isCaseSensitive(this.subDef.find, this.subDef.flags);
            this.useRegex = this.editorAdaptor.getConfiguration().get(Options.SEARCH_REGEX);
            this.nextLine = hint.startLine;
            TextContent model = this.editorAdaptor.getModelContent();
            this.totalLength = model.getTextLength();
            this.endOffset = hint.endLine == model.getNumberOfLines() ? this.totalLength : model.getLineInformation(hint.endLine).getEndOffset();
        } else {
            this.exit();
            return;
        }
        this.commandLine = this.editorAdaptor.getCommandLine();
        this.commandLine.setPrompt("replace with " + this.subDef.replace + " (y/n/a/q/l)?");
        this.commandLine.open();
        this.findNextMatch(true);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.leaveMode(hints);
        this.commandLine.close();
    }

    private void findNextMatch(boolean doHighlight) {
        int startOffset;
        if (this.lastMatch != null && this.globalFlag) {
            startOffset = this.lastMatch.getRightBound().getModelOffset() + this.replaceOffset;
            this.replaceOffset = 0;
        } else {
            startOffset = this.editorAdaptor.getModelContent().getLineInformation(this.nextLine).getBeginOffset();
        }
        SearchOffset.Begin afterSearch = new SearchOffset.Begin(startOffset);
        Search search = new Search(this.subDef.find, false, this.caseSensitive, afterSearch, this.useRegex);
        SearchAndReplaceService searchService = this.editorAdaptor.getSearchAndReplaceService();
        Position start = this.editorAdaptor.getCursorService().newPositionForModelOffset(startOffset);
        SearchResult result = searchService.find(search, start);
        if (result.getStart() == null || result.getRightBound().getModelOffset() > this.endOffset) {
            this.exit();
            return;
        }
        if (result.getLeftBound().getViewOffset() < 0) {
            this.editorAdaptor.getViewportService().exposeModelPosition(result.getLeftBound());
        }
        this.editorAdaptor.setPosition(result.getLeftBound(), StickyColumnPolicy.NEVER);
        if (doHighlight) {
            CenterLineCommand.CENTER.execute(this.editorAdaptor);
            searchService.incSearchhighlight(result.getLeftBound(), result.getModelLength());
        }
        this.lastMatch = result;
        this.nextLine = this.editorAdaptor.getModelContent().getLineInformationOfOffset(this.lastMatch.getRightBound().getModelOffset()).getNumber() + 1;
    }

    @Override
    public boolean handleKey(KeyStroke stroke) {
        if (stroke.equals(KEY_ESCAPE)) {
            this.exit();
            return true;
        }
        switch (stroke.getCharacter()) {
            case 'y': {
                this.performSubstitution();
                this.findNextMatch(true);
                break;
            }
            case 'n': {
                this.findNextMatch(true);
                break;
            }
            case 'a': {
                this.replaceAll();
                this.exit();
                break;
            }
            case 'l': {
                this.performSubstitution();
                this.exit();
                break;
            }
            case 'q': {
                this.exit();
                break;
            }
        }
        return true;
    }

    private void exit() {
        this.lastMatch = null;
        this.editorAdaptor.getSearchAndReplaceService().removeIncSearchHighlighting();
        this.editorAdaptor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
    }

    private void replaceAll() {
        this.editorAdaptor.getHistory().beginCompoundChange();
        while (this.lastMatch != null) {
            this.performSubstitution();
            this.findNextMatch(false);
        }
        this.editorAdaptor.getHistory().endCompoundChange();
    }

    private void performSubstitution() {
        this.editorAdaptor.getSearchAndReplaceService().substitute(this.lastMatch.getLeftBound().getModelOffset(), this.subDef.find, this.subDef.flags, this.subDef.replace);
        int newTotal = this.editorAdaptor.getModelContent().getTextLength();
        this.replaceOffset = newTotal - this.totalLength;
        this.endOffset += this.replaceOffset;
        this.totalLength = newTotal;
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return null;
    }

    public static class SubstitutionConfirm
    implements ModeSwitchHint {
        protected SubstitutionDefinition subDef;
        protected int startLine;
        protected int endLine;

        public SubstitutionConfirm(SubstitutionDefinition subDef, int startLine, int endLine) {
            this.subDef = subDef;
            this.startLine = startLine;
            this.endLine = endLine;
        }
    }
}

