/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.PlatformSpecificStateProvider;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.SwitchRegisterCommand;
import net.sourceforge.vrapper.vim.commands.VimCommandSequence;
import net.sourceforge.vrapper.vim.commands.motions.ContinueFindingMotion;
import net.sourceforge.vrapper.vim.commands.motions.FindCharMotion;
import net.sourceforge.vrapper.vim.commands.motions.GoToEditLocation;
import net.sourceforge.vrapper.vim.commands.motions.GoToLineMotion;
import net.sourceforge.vrapper.vim.commands.motions.GoToMarkMotion;
import net.sourceforge.vrapper.vim.commands.motions.LastCharacterMotion;
import net.sourceforge.vrapper.vim.commands.motions.LineEndMotion;
import net.sourceforge.vrapper.vim.commands.motions.LineStartMotion;
import net.sourceforge.vrapper.vim.commands.motions.MethodDeclarationMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveBigWORDEndLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveBigWORDEndRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveBigWORDLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveBigWORDRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveDown;
import net.sourceforge.vrapper.vim.commands.motions.MoveLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveLeftAcrossLines;
import net.sourceforge.vrapper.vim.commands.motions.MoveRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveRightAcrossLines;
import net.sourceforge.vrapper.vim.commands.motions.MoveToColumn;
import net.sourceforge.vrapper.vim.commands.motions.MoveUp;
import net.sourceforge.vrapper.vim.commands.motions.MoveUpDownNonWhitespace;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordEndLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordEndRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordRight;
import net.sourceforge.vrapper.vim.commands.motions.PageScrollMotion;
import net.sourceforge.vrapper.vim.commands.motions.ParagraphMotion;
import net.sourceforge.vrapper.vim.commands.motions.ParenthesesMove;
import net.sourceforge.vrapper.vim.commands.motions.PercentMotion;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.commands.motions.SectionMotion;
import net.sourceforge.vrapper.vim.commands.motions.SentenceMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.commands.motions.ViewPortMotion;
import net.sourceforge.vrapper.vim.commands.motions.WordSearchMotion;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.KeyMapResolver;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.register.RegisterManager;

public abstract class CommandBasedMode
extends AbstractMode {
    private static State<Motion> motions;
    protected final State<Command> initialState = this.getInitialState();
    protected State<Command> currentState = this.initialState;
    private final KeyMapResolver keyMapResolver = this.buildKeyMapResolver();
    private final StringBuilder commandBuffer = new StringBuilder();
    protected int commandBufferRemapIndex = -1;
    private static Map<String, State<Command>> initialStateCache;

    static {
        initialStateCache = new HashMap<String, State<Command>>();
    }

    public CommandBasedMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public void enterMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.enterMode(hints);
        this.commandBufferRemapIndex = -1;
        this.reset();
    }

    public abstract void placeCursor(StickyColumnPolicy var1);

    protected abstract State<Command> buildInitialState();

    protected abstract KeyMapResolver buildKeyMapResolver();

    public State<Command> getInitialState() {
        String key = this.getName();
        PlatformSpecificStateProvider platformSpecificStateProvider = this.editorAdaptor.getPlatformSpecificStateProvider();
        if (platformSpecificStateProvider != null) {
            key = String.valueOf(key) + " for " + platformSpecificStateProvider.getName();
        }
        if (!initialStateCache.containsKey(key)) {
            initialStateCache.put(key, this.buildInitialState());
        }
        return initialStateCache.get(key);
    }

    public static State<Motion> motions() {
        if (motions == null) {
            Motion moveLeft = MoveLeft.INSTANCE;
            Motion moveRight = MoveRight.INSTANCE;
            Motion moveUp = MoveUp.INSTANCE;
            Motion moveDown = MoveDown.INSTANCE;
            MoveUpDownNonWhitespace moveDownNonWhitespace = MoveUpDownNonWhitespace.MOVE_DOWN;
            MoveUpDownNonWhitespace moveDownLessOneNonWhitespace = MoveUpDownNonWhitespace.MOVE_DOWN_LESS_ONE;
            MoveUpDownNonWhitespace moveUpNonWhitespace = MoveUpDownNonWhitespace.MOVE_UP;
            MoveToColumn moveToColumn = MoveToColumn.INSTANCE;
            SearchResultMotion findNext = SearchResultMotion.REPEAT;
            SearchResultMotion findPrevious = SearchResultMotion.REPEAT_REVERSED;
            WordSearchMotion findWordNext = WordSearchMotion.FORWARD;
            WordSearchMotion findWordPrevious = WordSearchMotion.BACKWARD;
            WordSearchMotion findWordForwardLenient = WordSearchMotion.LENIENT_FORWARD;
            WordSearchMotion findWordBackwardLenient = WordSearchMotion.LENIENT_BACKWARD;
            MoveWordRight wordRight = MoveWordRight.INSTANCE;
            MoveBigWORDRight WORDRight = MoveBigWORDRight.INSTANCE;
            MoveWordLeft wordLeft = MoveWordLeft.INSTANCE;
            MoveBigWORDLeft WORDLeft = MoveBigWORDLeft.INSTANCE;
            MoveWordEndRight wordEndRight = MoveWordEndRight.INSTANCE;
            MoveBigWORDEndRight WORDEndRight = MoveBigWORDEndRight.INSTANCE;
            MoveWordEndLeft wordEndLeft = MoveWordEndLeft.INSTANCE;
            Motion WORDEndLeft = MoveBigWORDEndLeft.INSTANCE;
            ParagraphMotion paragraphForward = ParagraphMotion.FORWARD;
            ParagraphMotion paragraphBackward = ParagraphMotion.BACKWARD;
            SentenceMotion sentenceForward = SentenceMotion.FORWARD;
            SentenceMotion sentenceBackward = SentenceMotion.BACKWARD;
            LineStartMotion lineStart = LineStartMotion.NON_WHITESPACE;
            LineStartMotion column0 = LineStartMotion.COLUMN0;
            LineEndMotion lineEnd = new LineEndMotion(BorderPolicy.EXCLUSIVE);
            Motion percentMotion = PercentMotion.INSTANCE;
            ParenthesesMove matchOpenParen = ParenthesesMove.MATCH_OPEN_PAREN;
            ParenthesesMove matchCloseParen = ParenthesesMove.MATCH_CLOSE_PAREN;
            ParenthesesMove matchOpenCurly = ParenthesesMove.MATCH_OPEN_CURLY;
            ParenthesesMove matchCloseCurly = ParenthesesMove.MATCH_CLOSE_CURLY;
            MethodDeclarationMotion methodNextStart = MethodDeclarationMotion.NEXT_START;
            MethodDeclarationMotion methodPrevStart = MethodDeclarationMotion.PREV_START;
            MethodDeclarationMotion methodNextEnd = MethodDeclarationMotion.NEXT_END;
            MethodDeclarationMotion methodPrevEnd = MethodDeclarationMotion.PREV_END;
            SectionMotion sectionNextStart = SectionMotion.NEXT_START;
            SectionMotion sectionPrevStart = SectionMotion.PREV_START;
            SectionMotion sectionNextEnd = SectionMotion.NEXT_END;
            SectionMotion sectionPrevEnd = SectionMotion.PREV_END;
            ContinueFindingMotion findForward = ContinueFindingMotion.NORMAL;
            ContinueFindingMotion findBackward = ContinueFindingMotion.REVERSE;
            ViewPortMotion highMove = ViewPortMotion.HIGH;
            ViewPortMotion middleMove = ViewPortMotion.MIDDLE;
            ViewPortMotion lowMove = ViewPortMotion.LOW;
            motions = ConstructorWrappers.state(ConstructorWrappers.leafBind('h', moveLeft), ConstructorWrappers.leafBind('j', moveDown), ConstructorWrappers.leafBind('k', moveUp), ConstructorWrappers.leafBind('l', moveRight), ConstructorWrappers.leafBind('|', moveToColumn), ConstructorWrappers.leafBind(SpecialKey.RETURN, moveDownNonWhitespace), ConstructorWrappers.leafBind('+', moveDownNonWhitespace), ConstructorWrappers.leafBind('-', moveUpNonWhitespace), ConstructorWrappers.leafBind('_', moveDownLessOneNonWhitespace), ConstructorWrappers.leafBind(' ', MoveRightAcrossLines.INSTANCE), ConstructorWrappers.leafBind(SpecialKey.BACKSPACE, MoveLeftAcrossLines.INSTANCE), ConstructorWrappers.leafBind(SpecialKey.ARROW_LEFT, moveLeft), ConstructorWrappers.leafBind(SpecialKey.ARROW_DOWN, moveDown), ConstructorWrappers.leafBind(SpecialKey.ARROW_UP, moveUp), ConstructorWrappers.leafBind(SpecialKey.ARROW_RIGHT, moveRight), ConstructorWrappers.leafCtrlBind('f', PageScrollMotion.SCROLL_PGDN), ConstructorWrappers.leafCtrlBind('b', PageScrollMotion.SCROLL_PGUP), ConstructorWrappers.leafCtrlBind('d', PageScrollMotion.SCROLL_HALF_PGDN), ConstructorWrappers.leafCtrlBind('u', PageScrollMotion.SCROLL_HALF_PGUP), ConstructorWrappers.leafBind(SpecialKey.PAGE_DOWN, PageScrollMotion.SCROLL_PGDN), ConstructorWrappers.leafBind(SpecialKey.PAGE_UP, PageScrollMotion.SCROLL_PGUP), ConstructorWrappers.leafBind(';', findForward), ConstructorWrappers.leafBind(',', findBackward), ConstructorWrappers.transitionBind('t', ConstructorWrappers.convertKeyStroke(FindCharMotion.keyConverter(false, false), VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('T', ConstructorWrappers.convertKeyStroke(FindCharMotion.keyConverter(false, true), VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('f', ConstructorWrappers.convertKeyStroke(FindCharMotion.keyConverter(true, false), VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('F', ConstructorWrappers.convertKeyStroke(FindCharMotion.keyConverter(true, true), VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('\'', ConstructorWrappers.convertKeyStroke(GoToMarkMotion.LINEWISE_CONVERTER, VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('`', ConstructorWrappers.convertKeyStroke(GoToMarkMotion.CHARWISE_CONVERTER, VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.leafBind('w', wordRight), ConstructorWrappers.leafBind('W', WORDRight), ConstructorWrappers.leafBind('e', wordEndRight), ConstructorWrappers.leafBind('E', WORDEndRight), ConstructorWrappers.leafBind('b', wordLeft), ConstructorWrappers.leafBind('B', WORDLeft), ConstructorWrappers.leafBind('}', paragraphForward), ConstructorWrappers.leafBind('{', paragraphBackward), ConstructorWrappers.leafBind(')', sentenceForward), ConstructorWrappers.leafBind('(', sentenceBackward), ConstructorWrappers.leafBind('G', GoToLineMotion.LAST_LINE), ConstructorWrappers.leafBind('H', highMove), ConstructorWrappers.leafBind('M', middleMove), ConstructorWrappers.leafBind('L', lowMove), ConstructorWrappers.leafBind('n', findNext), ConstructorWrappers.leafBind('N', findPrevious), ConstructorWrappers.leafBind('*', findWordNext), ConstructorWrappers.leafBind('#', findWordPrevious), ConstructorWrappers.leafBind('0', column0), ConstructorWrappers.leafBind('$', lineEnd), ConstructorWrappers.leafBind(SpecialKey.HOME, lineStart), ConstructorWrappers.leafBind(SpecialKey.END, lineEnd), ConstructorWrappers.leafBind('%', percentMotion), ConstructorWrappers.leafBind('^', lineStart), ConstructorWrappers.leafCtrlBind(SpecialKey.HOME, GoToLineMotion.FIRST_LINE), ConstructorWrappers.leafCtrlBind(SpecialKey.END, LastCharacterMotion.FILE), ConstructorWrappers.transitionBind('[', ConstructorWrappers.leafBind('m', methodPrevStart), ConstructorWrappers.leafBind('M', methodPrevEnd), ConstructorWrappers.leafBind('[', sectionPrevStart), ConstructorWrappers.leafBind(']', sectionPrevEnd), ConstructorWrappers.leafBind('(', matchOpenParen), ConstructorWrappers.leafBind('{', matchOpenCurly)), ConstructorWrappers.transitionBind(']', ConstructorWrappers.leafBind('m', methodNextStart), ConstructorWrappers.leafBind('M', methodNextEnd), ConstructorWrappers.leafBind(']', sectionNextStart), ConstructorWrappers.leafBind('[', sectionNextEnd), ConstructorWrappers.leafBind(')', matchCloseParen), ConstructorWrappers.leafBind('}', matchCloseCurly)), ConstructorWrappers.transitionBind('g', ConstructorWrappers.leafBind('g', GoToLineMotion.FIRST_LINE), ConstructorWrappers.leafBind('*', findWordForwardLenient), ConstructorWrappers.leafBind('#', findWordBackwardLenient), ConstructorWrappers.leafBind('_', LastCharacterMotion.LINE), ConstructorWrappers.leafBind(';', GoToEditLocation.BACKWARDS), ConstructorWrappers.leafBind(',', GoToEditLocation.FORWARD), ConstructorWrappers.leafBind('e', wordEndLeft), ConstructorWrappers.leafBind('E', WORDEndLeft)));
        }
        return motions;
    }

    public void executeCommand(Command command) throws CommandExecutionException {
        this.editorAdaptor.getListeners().fireCommandAboutToExecute();
        command.execute(this.editorAdaptor);
        this.editorAdaptor.getListeners().fireCommandExecuted();
        Command repetition = (Command)command.repetition();
        if (repetition != null) {
            RegisterManager registerManager = this.editorAdaptor.getRegisterManager();
            if (!registerManager.isDefaultRegisterActive()) {
                repetition = new VimCommandSequence(new SwitchRegisterCommand(registerManager.getActiveRegister()), repetition);
            }
            registerManager.setLastEdit(repetition);
            this.editorAdaptor.getCursorService().setMark(".", this.editorAdaptor.getPosition());
            registerManager.activateDefaultRegister();
        }
    }

    @Override
    public boolean handleKey(KeyStroke keyStroke) {
        Transition<Command> transition;
        if (this.editorAdaptor == null) {
            return false;
        }
        if (this.currentState == null) {
            VrapperLog.error("current state was null - this shouldn't have happened!");
            this.reset();
            this.editorAdaptor.getListeners().fireStateReset(false);
        }
        if (!keyStroke.isVirtual()) {
            this.editorAdaptor.getUserInterfaceService().setErrorMessage(null);
        }
        if ((transition = this.currentState.press(keyStroke)) == null && VimUtils.fixAltGrKey(keyStroke) != null) {
            KeyStroke key = VimUtils.fixAltGrKey(keyStroke);
            transition = this.currentState.press(key);
            this.keyMapResolver.storeKey(key);
        } else {
            this.keyMapResolver.storeKey(keyStroke);
        }
        this.commandBuffer.append(keyStroke.getCharacter());
        boolean recognized = false;
        if (transition != null) {
            Command command = transition.getValue();
            this.currentState = transition.getNextState();
            if (command != null) {
                recognized = true;
                try {
                    this.executeCommand(command);
                }
                catch (CommandExecutionException e) {
                    this.setErrorMessage(e.getMessage());
                    this.reset();
                    this.editorAdaptor.getListeners().fireStateReset(true);
                    this.commandDone();
                    this.isEnabled = true;
                }
            }
        }
        if (transition == null || this.currentState == null) {
            this.reset();
            this.editorAdaptor.getListeners().fireStateReset(recognized);
            if (this.isEnabled) {
                this.commandDone();
            }
        }
        if (this.editorAdaptor.getUserInterfaceService().isInfoSet()) {
            this.resetCommandBuffer();
            this.editorAdaptor.getUserInterfaceService().setInfoMessage(this.editorAdaptor.getUserInterfaceService().getLastCommandResultValue());
            this.editorAdaptor.getUserInterfaceService().setInfoSet(false);
        } else {
            this.editorAdaptor.getUserInterfaceService().setInfoMessage(this.commandBuffer.toString());
        }
        this.placeCursor(StickyColumnPolicy.NEVER);
        return true;
    }

    private void setErrorMessage(String message) {
        this.editorAdaptor.getUserInterfaceService().setErrorMessage(message);
    }

    private void reset() {
        this.currentState = this.initialState;
        this.keyMapResolver.reset();
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return this.keyMapResolver.getKeyMapName(stroke);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.leaveMode(hints);
        this.resetCommandBuffer();
    }

    @Override
    public boolean isRemapBacktracking() {
        return false;
    }

    protected void commandDone() {
        this.resetCommandBuffer();
    }

    @Override
    public void addKeyToMapBuffer(KeyStroke stroke) {
        String keyStrokeString = ConstructorWrappers.keyStrokeToString(stroke);
        if (this.commandBufferRemapIndex == -1) {
            this.commandBufferRemapIndex = this.commandBuffer.length();
        }
        this.commandBuffer.append(keyStrokeString);
        this.editorAdaptor.getUserInterfaceService().setInfoMessage(this.commandBuffer.toString());
    }

    @Override
    public void cleanMapBuffer(boolean mappingSucceeded) {
        if (this.commandBufferRemapIndex > -1) {
            this.commandBuffer.delete(this.commandBufferRemapIndex, this.commandBuffer.length());
        }
        this.editorAdaptor.getUserInterfaceService().setInfoMessage(this.commandBuffer.toString());
    }

    private void resetCommandBuffer() {
        this.commandBuffer.delete(0, this.commandBuffer.length());
        this.editorAdaptor.getUserInterfaceService().setInfoMessage("");
        this.commandBufferRemapIndex = -1;
    }

    protected State<Command> getPlatformSpecificState(String mode) {
        State<Command> platformSpecificState = this.editorAdaptor.getPlatformSpecificStateProvider().getState(mode);
        if (platformSpecificState == null) {
            platformSpecificState = EmptyState.getInstance();
        }
        return platformSpecificState;
    }
}

