/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.CountingState;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.BlockWiseSelectionArea;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SelectionArea;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.BlockwiseChangeOperation;
import net.sourceforge.vrapper.vim.commands.BlockwiseInsertShiftWidth;
import net.sourceforge.vrapper.vim.commands.BlockwisePasteCommand;
import net.sourceforge.vrapper.vim.commands.BlockwiseYankCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToInsertModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.ReplaceCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SelectionBasedTextOperationCommand;
import net.sourceforge.vrapper.vim.commands.SwapBlockwiseSelectionSidesCommand;
import net.sourceforge.vrapper.vim.commands.SwapCaseCommand;
import net.sourceforge.vrapper.vim.commands.motions.BlockSelectionMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.WithCountHint;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public class BlockwiseVisualMode
extends AbstractVisualMode {
    public static final String NAME = "block visual mode";
    public static final String DISPLAY_NAME = "BLOCK VISUAL";

    public BlockwiseVisualMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected State<Command> buildInitialState() {
        BlockSelectionMotion bol = BlockSelectionMotion.COLUMN_START;
        BlockSelectionMotion eol = BlockSelectionMotion.COLUMN_END;
        SwapCaseCommand swapCase = SwapCaseCommand.VISUALBLOCK_INSTANCE;
        SelectionBasedTextOperationCommand.DontChangeMode change = new SelectionBasedTextOperationCommand.DontChangeMode(BlockwiseChangeOperation.INSTANCE);
        State<Command> parentState = super.buildInitialState();
        return StateUtils.union(ConstructorWrappers.state(ConstructorWrappers.leafBind('c', change), ConstructorWrappers.leafBind('C', change), ConstructorWrappers.leafBind('s', change), ConstructorWrappers.leafBind('o', SwapBlockwiseSelectionSidesCommand.DIAGONAL_INSTANCE), ConstructorWrappers.leafBind('O', SwapBlockwiseSelectionSidesCommand.HORIZONTAL_INSTANCE), ConstructorWrappers.leafBind('I', new BlockwiseChangeToInsertModeCommand(new MotionCommand(bol), InsertModeType.INSERT)), ConstructorWrappers.leafBind('A', new BlockwiseChangeToInsertModeCommand(new MotionCommand(eol), InsertModeType.APPEND)), ConstructorWrappers.leafBind('~', swapCase), ConstructorWrappers.leafBind('y', BlockwiseYankCommand.INSTANCE), ConstructorWrappers.leafBind('v', new ChangeToVisualModeCommand("visual mode")), ConstructorWrappers.leafBind('V', new ChangeToVisualModeCommand("linewise visual mode")), ConstructorWrappers.leafCtrlBind('v', LeaveVisualModeCommand.INSTANCE), ConstructorWrappers.leafCtrlBind('q', LeaveVisualModeCommand.INSTANCE), ConstructorWrappers.transitionBind('r', ConstructorWrappers.changeCaret(CaretType.UNDERLINE), ConstructorWrappers.convertKeyStroke(ReplaceCommand.VisualBlock.VISUALBLOCK_KEYSTROKE, VimConstants.PRINTABLE_KEYSTROKES_WITH_NL))), CountingState.wrap(ConstructorWrappers.state(ConstructorWrappers.leafBind('>', new SelectionBasedTextOperationCommand(BlockwiseInsertShiftWidth.INSERT)), ConstructorWrappers.leafBind('<', new SelectionBasedTextOperationCommand(BlockwiseInsertShiftWidth.REMOVE)), ConstructorWrappers.leafBind('p', BlockwisePasteCommand.INSTANCE))), parentState);
    }

    @Override
    public void fixCaret() {
        CaretType caret = CaretType.RECTANGULAR;
        this.editorAdaptor.getCursorService().setCaret(caret);
    }

    @Override
    protected Selection fixSelection(Selection selection) {
        Position start = selection.getFrom();
        Position end = selection.getTo();
        return new BlockWiseSelection(this.editorAdaptor, start, end);
    }

    private static class BlockwiseChangeToInsertModeCommand
    extends ChangeToInsertModeCommand
    implements Command {
        private final InsertModeType mode;

        public BlockwiseChangeToInsertModeCommand(Command command, InsertModeType mode) {
            super(command);
            this.mode = mode;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            if (this.command == null) {
                throw new CommandExecutionException("Illegal state; command must not be null!");
            }
            editorAdaptor.rememberLastActiveSelection();
            editorAdaptor.setSelection(null);
            HistoryService history = editorAdaptor.getHistory();
            history.beginCompoundChange();
            history.lock("block-action");
            editorAdaptor.changeMode("insert mode", new ExecuteCommandHint.OnEnter(this.command), new ExecuteCommandHint.OnLeave(this.mode == InsertModeType.INSERT ? BlockwiseRepeatInsertCommand.INSERT_INSTANCE : BlockwiseRepeatInsertCommand.APPEND_INSTANCE), new WithCountHint(count));
        }
    }

    private static class BlockwiseRepeatInsertCommand
    implements Command {
        private final InsertModeType mode;
        public static final Command INSERT_INSTANCE = new BlockwiseRepeatInsertCommand(InsertModeType.INSERT);
        public static final Command APPEND_INSTANCE = new BlockwiseRepeatInsertCommand(InsertModeType.APPEND);
        public static final Command REPEAT_INSERT_INSTANCE = new Repetition(InsertModeType.INSERT);
        public static final Command REPEAT_APPEND_INSTANCE = new Repetition(InsertModeType.APPEND);

        BlockwiseRepeatInsertCommand(InsertModeType mode) {
            this.mode = mode;
        }

        @Override
        public Command repetition() {
            return this.mode == InsertModeType.INSERT ? REPEAT_INSERT_INSTANCE : REPEAT_APPEND_INSTANCE;
        }

        @Override
        public Command withCount(int count) {
            return this;
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            SelectionArea sel = editorAdaptor.getRegisterManager().getLastActiveSelectionArea();
            Command insertion = editorAdaptor.getRegisterManager().getLastInsertion();
            Register lastEdit = editorAdaptor.getRegisterManager().getLastEditRegister();
            RegisterContent content = lastEdit.getContent();
            if (!(content instanceof StringRegisterContent) || insertion == null) {
                this.finish(editorAdaptor);
                return;
            }
            StringRegisterContent stringInsert = (StringRegisterContent)content;
            String string = stringInsert.getText();
            if (VimUtils.containsNewLine(string)) {
                this.finish(editorAdaptor);
                return;
            }
            CursorService cursorService = editorAdaptor.getCursorService();
            Position newStart = cursorService.getMark("[");
            editorAdaptor.setPosition(newStart, StickyColumnPolicy.NEVER);
            TextContent modelContent = editorAdaptor.getModelContent();
            if (this.mode == InsertModeType.INSERT) {
                TextRange region = sel.getRegion(editorAdaptor, 0);
                BlockWiseSelection.TextBlock block = BlockWiseSelection.getTextBlock(region.getStart(), region.getEnd(), modelContent, cursorService);
                int line = block.startLine + 1;
                while (line <= block.endLine) {
                    BlockwiseRepeatInsertCommand.executeInsertAtVOffset(editorAdaptor, insertion, block.startVisualOffset, line, this.mode);
                    ++line;
                }
            } else {
                LineInformation lineInfo = modelContent.getLineInformationOfOffset(newStart.getModelOffset());
                int startLine = lineInfo.getNumber();
                int endLine = Math.min(startLine + sel.getLinesSpanned(), modelContent.getNumberOfLines());
                BlockWiseSelectionArea bsel = (BlockWiseSelectionArea)sel;
                if (bsel.isUntilEOL()) {
                    int line = startLine + 1;
                    while (line < endLine) {
                        lineInfo = modelContent.getLineInformation(line);
                        Position pos = cursorService.newPositionForModelOffset(lineInfo.getEndOffset());
                        editorAdaptor.setPosition(pos, StickyColumnPolicy.NEVER);
                        insertion.execute(editorAdaptor);
                        ++line;
                    }
                } else {
                    int vOffset = cursorService.getVisualOffset(newStart);
                    int line = startLine + 1;
                    while (line < endLine) {
                        BlockwiseRepeatInsertCommand.executeInsertAtVOffset(editorAdaptor, insertion, vOffset, line, this.mode);
                        ++line;
                    }
                }
            }
            editorAdaptor.setPosition(newStart, StickyColumnPolicy.NEVER);
            editorAdaptor.getRegisterManager().setLastEdit(this.repetition());
            this.finish(editorAdaptor);
        }

        static void executeInsertAtVOffset(EditorAdaptor editorAdaptor, Command insertion, int vOffset, int line, InsertModeType mode) throws CommandExecutionException {
            CursorService cursorService = editorAdaptor.getCursorService();
            TextContent modelContent = editorAdaptor.getModelContent();
            Position pos = cursorService.getPositionByVisualOffset(line, vOffset);
            if (pos == null && mode == InsertModeType.APPEND) {
                LineInformation lineInfo = modelContent.getLineInformation(line);
                pos = cursorService.newPositionForModelOffset(lineInfo.getEndOffset());
                int lineEndVOfs = cursorService.getVisualOffset(pos);
                int padding = cursorService.visualWidthToChars(vOffset - lineEndVOfs);
                modelContent.replace(lineInfo.getEndOffset(), 0, StringUtils.multiply(" ", padding));
                pos = pos.addModelOffset(padding);
            }
            if (pos != null) {
                editorAdaptor.setPosition(pos, StickyColumnPolicy.NEVER);
                insertion.execute(editorAdaptor);
            }
        }

        private void finish(EditorAdaptor editorAdaptor) {
            HistoryService history = editorAdaptor.getHistory();
            history.unlock("block-action");
            history.endCompoundChange();
        }
    }

    static enum InsertModeType {
        INSERT,
        APPEND;

    }

    public static class Repetition
    extends CountAwareCommand {
        private final InsertModeType mode;

        public Repetition(InsertModeType mode) {
            this.mode = mode;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            SelectionArea sel = editorAdaptor.getRegisterManager().getLastActiveSelectionArea();
            if (sel.getContentType(editorAdaptor.getConfiguration()) != ContentType.TEXT_RECTANGLE) {
                return;
            }
            HistoryService history = editorAdaptor.getHistory();
            Command insertion = editorAdaptor.getRegisterManager().getLastInsertion();
            TextRange region = sel.getRegion(editorAdaptor, count);
            CursorService cursorService = editorAdaptor.getCursorService();
            Position regionStart = region.getStart();
            if (this.mode == InsertModeType.APPEND) {
                regionStart = regionStart.addModelOffset(1);
            }
            history.beginCompoundChange();
            history.lock("block-action");
            if (this.mode == InsertModeType.INSERT) {
                BlockWiseSelection.TextBlock block = BlockWiseSelection.getTextBlock(regionStart, region.getEnd(), editorAdaptor.getModelContent(), cursorService);
                int line = block.startLine;
                while (line <= block.endLine) {
                    BlockwiseRepeatInsertCommand.executeInsertAtVOffset(editorAdaptor, insertion, block.startVisualOffset, line, this.mode);
                    ++line;
                }
            } else {
                TextContent modelContent = editorAdaptor.getModelContent();
                int vOffset = cursorService.getVisualOffset(regionStart);
                LineInformation lineInfo = modelContent.getLineInformationOfOffset(regionStart.getModelOffset());
                int startLine = lineInfo.getNumber();
                int endLine = Math.min(startLine + sel.getLinesSpanned(), modelContent.getNumberOfLines());
                int line = startLine;
                while (line < endLine) {
                    BlockwiseRepeatInsertCommand.executeInsertAtVOffset(editorAdaptor, insertion, vOffset, line, this.mode);
                    ++line;
                }
            }
            editorAdaptor.setPosition(regionStart, StickyColumnPolicy.ON_CHANGE);
            history.unlock("block-action");
            history.endCompoundChange();
        }

        @Override
        public CountAwareCommand repetition() {
            return this;
        }
    }
}

