/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.KeyMapInfo;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.CountConsumingKeyMapState;
import net.sourceforge.vrapper.keymap.vim.CountingState;
import net.sourceforge.vrapper.keymap.vim.RegisterState;
import net.sourceforge.vrapper.keymap.vim.VisualMotionState;
import net.sourceforge.vrapper.keymap.vim.VisualTextObjectState;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.CenterLineCommand;
import net.sourceforge.vrapper.vim.commands.ChangeModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeOperation;
import net.sourceforge.vrapper.vim.commands.ChangeToVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.FormatOperation;
import net.sourceforge.vrapper.vim.commands.InsertShiftWidth;
import net.sourceforge.vrapper.vim.commands.JoinVisualLinesCommand;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.PasteOperation;
import net.sourceforge.vrapper.vim.commands.PrintTextRangeInformation;
import net.sourceforge.vrapper.vim.commands.ReplaceCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SelectionBasedTextOperationCommand;
import net.sourceforge.vrapper.vim.commands.SetMarkCommand;
import net.sourceforge.vrapper.vim.commands.SwapCaseCommand;
import net.sourceforge.vrapper.vim.commands.VisualFindFileCommand;
import net.sourceforge.vrapper.vim.commands.VisualMotionCommand;
import net.sourceforge.vrapper.vim.commands.YankOperation;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveDown;
import net.sourceforge.vrapper.vim.commands.motions.MoveLeft;
import net.sourceforge.vrapper.vim.commands.motions.MoveRight;
import net.sourceforge.vrapper.vim.commands.motions.MoveRightAcrossLines;
import net.sourceforge.vrapper.vim.commands.motions.MoveUp;
import net.sourceforge.vrapper.vim.commands.motions.MoveWordEndLeft;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.CommandBasedMode;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.KeyMapResolver;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.RegisterKeymapState;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineMode;

public abstract class AbstractVisualMode
extends CommandBasedMode {
    public static final String NAME = "all visual modes";
    public static final String KEYMAP_NAME = "Visual Mode Keymap";
    public static final ModeSwitchHint FIX_SELECTION_HINT = new ModeSwitchHint(){};
    public static final ModeSwitchHint KEEP_SELECTION_HINT = new ModeSwitchHint(){};
    public static final ModeSwitchHint RECALL_SELECTION_HINT = new ModeSwitchHint(){};
    public static final ModeSwitchHint MOVE_CURSOR_HINT = new ModeSwitchHint(){};

    public AbstractVisualMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    protected KeyMapResolver buildKeyMapResolver() {
        State<KeyMapInfo> state = StateUtils.union(this.editorAdaptor.getPlatformSpecificStateProvider().getKeyMaps("visual mode"));
        CountConsumingKeyMapState countEater = new CountConsumingKeyMapState(KEYMAP_NAME, "innercount", state);
        RegisterKeymapState registerKeymapState = new RegisterKeymapState(KEYMAP_NAME, countEater);
        CountConsumingKeyMapState outerCountEater = new CountConsumingKeyMapState(KEYMAP_NAME, "outercount", registerKeymapState);
        return new KeyMapResolver(outerCountEater, KEYMAP_NAME);
    }

    @Override
    public void placeCursor(StickyColumnPolicy stickyColumnPolicy) {
        if (this.isEnabled) {
            this.fixCaret();
        }
    }

    @Override
    public void enterMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        boolean fixSelection = false;
        boolean keepSelection = false;
        boolean recallSelection = false;
        ExecuteCommandHint onEnterCommand = null;
        ModeSwitchHint[] modeSwitchHintArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            ModeSwitchHint hint = modeSwitchHintArray[n2];
            if (hint == FIX_SELECTION_HINT) {
                keepSelection = true;
                fixSelection = true;
            }
            if (hint == KEEP_SELECTION_HINT) {
                keepSelection = true;
            }
            if (hint == RECALL_SELECTION_HINT) {
                recallSelection = true;
            }
            if (hint instanceof ExecuteCommandHint) {
                onEnterCommand = (ExecuteCommandHint)hint;
            }
            ++n2;
        }
        if (recallSelection) {
            Selection previousSel = this.editorAdaptor.getLastActiveSelection();
            CursorService cursorService = this.editorAdaptor.getCursorService();
            Position from = cursorService.getMark("x-vrapper-sel-from");
            Position to = cursorService.getMark("x-vrapper-sel-to");
            if (previousSel == null) {
                VrapperLog.info("Previous selection was null, selection not recalled.");
            } else {
                Selection updatedSel = this.updateSelection(this.editorAdaptor, previousSel, from, to);
                this.editorAdaptor.setPosition(updatedSel.getTo(), StickyColumnPolicy.ON_CHANGE);
                this.editorAdaptor.setSelection(updatedSel);
            }
        } else if (!keepSelection) {
            this.editorAdaptor.setSelection(null);
        }
        Selection currentSelection = this.editorAdaptor.getSelection();
        if (fixSelection && currentSelection != null) {
            this.editorAdaptor.setSelection(this.fixSelection(currentSelection));
        }
        super.enterMode(hints);
        if (onEnterCommand != null) {
            try {
                super.executeCommand(onEnterCommand.getCommand());
            }
            catch (CommandExecutionException e) {
                this.editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
        }
        this.fixCaret();
    }

    private Selection updateSelection(EditorAdaptor editorAdaptor, Selection previousSel, Position from, Position to) {
        if (from == null && to == null) {
            VrapperLog.info("Previous selection marks are null, selection might be wrong.");
        } else if (from == null) {
            VrapperLog.info("Previous selection 'from' mark is null, selection might be wrong.");
        } else if (to == null) {
            VrapperLog.info("Previous selection 'to' mark is null, selection might be wrong.");
        }
        if (from == null) {
            from = previousSel.getFrom();
        }
        if (to == null) {
            to = previousSel.getTo();
        }
        return previousSel.reset(editorAdaptor, from, to);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.leaveMode(hints);
    }

    protected abstract Selection fixSelection(Selection var1);

    public abstract void fixCaret();

    @Override
    protected State<Command> buildInitialState() {
        Command leaveVisual = LeaveVisualModeCommand.INSTANCE;
        SelectionBasedTextOperationCommand yank = new SelectionBasedTextOperationCommand(YankOperation.INSTANCE);
        SelectionBasedTextOperationCommand delete = new SelectionBasedTextOperationCommand(DeleteOperation.INSTANCE);
        SelectionBasedTextOperationCommand paste = new SelectionBasedTextOperationCommand(PasteOperation.INSTANCE);
        SelectionBasedTextOperationCommand.DontChangeMode change = new SelectionBasedTextOperationCommand.DontChangeMode(ChangeOperation.INSTANCE);
        SelectionBasedTextOperationCommand format = new SelectionBasedTextOperationCommand(FormatOperation.INSTANCE);
        SelectionBasedTextOperationCommand shiftLeft = new SelectionBasedTextOperationCommand(InsertShiftWidth.REMOVE_VISUAL);
        SelectionBasedTextOperationCommand shiftRight = new SelectionBasedTextOperationCommand(InsertShiftWidth.INSERT_VISUAL);
        SwapCaseCommand swapCase = SwapCaseCommand.VISUAL_INSTANCE;
        ChangeModeCommand commandLineMode = new ChangeModeCommand("command mode", CommandLineMode.FROM_VISUAL);
        CenterLineCommand centerLine = CenterLineCommand.CENTER;
        CenterLineCommand centerBottomLine = CenterLineCommand.BOTTOM;
        CenterLineCommand centerTopLine = CenterLineCommand.TOP;
        Command joinLines = JoinVisualLinesCommand.INSTANCE;
        Command joinLinesDumbWay = JoinVisualLinesCommand.DUMB_INSTANCE;
        VisualFindFileCommand findFile = VisualFindFileCommand.INSTANCE;
        Command printTextRangeInformation = PrintTextRangeInformation.INSTANCE;
        VisualMotionState visualMotions = this.getVisualMotionState();
        VisualTextObjectState visualTextObjects = new VisualTextObjectState(this.editorAdaptor.getTextObjectProvider());
        State<Command> initialState = CountingState.wrap(RegisterState.wrap(CountingState.wrap(StateUtils.union(this.getPlatformSpecificState(NAME), ConstructorWrappers.state(ConstructorWrappers.leafBind(SpecialKey.ESC, leaveVisual), ConstructorWrappers.leafCtrlBind('c', leaveVisual), ConstructorWrappers.leafBind('y', yank), ConstructorWrappers.leafBind('s', change), ConstructorWrappers.leafBind('c', change), ConstructorWrappers.leafBind('C', change), ConstructorWrappers.leafBind('d', delete), ConstructorWrappers.leafBind('x', delete), ConstructorWrappers.leafBind('X', delete), ConstructorWrappers.leafBind(SpecialKey.DELETE, delete), ConstructorWrappers.leafBind('p', paste), ConstructorWrappers.leafBind('P', paste), ConstructorWrappers.leafBind('~', swapCase), ConstructorWrappers.leafBind('J', joinLines), ConstructorWrappers.leafBind(':', commandLineMode), ConstructorWrappers.leafBind('>', shiftRight), ConstructorWrappers.leafBind('<', shiftLeft), ConstructorWrappers.transitionBind('g', ConstructorWrappers.leafCtrlBind('g', printTextRangeInformation), ConstructorWrappers.leafBind('n', new ChangeToVisualModeCommand("visual mode", new VisualMotionCommand(SearchResultMotion.NEXT_END))), ConstructorWrappers.leafBind('N', new ChangeToVisualModeCommand("visual mode", new VisualMotionCommand(SearchResultMotion.PREVIOUS_BEGIN))), ConstructorWrappers.leafBind('f', findFile), ConstructorWrappers.leafBind('J', joinLinesDumbWay), ConstructorWrappers.leafBind('q', format)), ConstructorWrappers.transitionBind('z', ConstructorWrappers.leafBind('z', centerLine), ConstructorWrappers.leafBind('.', centerLine), ConstructorWrappers.leafBind('-', centerBottomLine), ConstructorWrappers.leafBind('b', centerBottomLine), ConstructorWrappers.leafBind('t', centerTopLine), ConstructorWrappers.leafBind(SpecialKey.RETURN, centerTopLine)), ConstructorWrappers.transitionBind('r', ConstructorWrappers.changeCaret(CaretType.UNDERLINE), ConstructorWrappers.convertKeyStroke(ReplaceCommand.Visual.VISUAL_KEYSTROKE, VimConstants.PRINTABLE_KEYSTROKES)), ConstructorWrappers.transitionBind('m', ConstructorWrappers.convertKeyStroke(SetMarkCommand.KEYSTROKE_CONVERTER, VimConstants.PRINTABLE_KEYSTROKES))), visualMotions, visualTextObjects))));
        return initialState;
    }

    protected VisualMotionState getVisualMotionState() {
        State<Motion> motions = StateUtils.union(ConstructorWrappers.leafState(' ', MoveRightAcrossLines.INSTANCE_BEHIND_CHAR), ConstructorWrappers.leafState(ConstructorWrappers.shiftKey(SpecialKey.ARROW_UP), MoveUp.INSTANCE), ConstructorWrappers.leafState(ConstructorWrappers.shiftKey(SpecialKey.ARROW_DOWN), MoveDown.INSTANCE), ConstructorWrappers.leafState(ConstructorWrappers.shiftKey(SpecialKey.ARROW_LEFT), MoveLeft.INSTANCE), ConstructorWrappers.leafState(ConstructorWrappers.shiftKey(SpecialKey.ARROW_RIGHT), MoveRight.INSTANCE), ConstructorWrappers.transitionState('g', ConstructorWrappers.state(ConstructorWrappers.leafBind('e', MoveWordEndLeft.INSTANCE_VISUAL))), AbstractVisualMode.motions());
        return new VisualMotionState(motions);
    }
}

