/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public abstract class UpDownMotion
extends CountAwareMotion {
    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) {
        if (count == 0) {
            count = 1;
        }
        TextContent content = editorAdaptor.getViewContent();
        int oldOffset = editorAdaptor.getPosition().getViewOffset();
        int lineNo = content.getLineInformationOfOffset(oldOffset).getNumber() + this.getJump() * count;
        lineNo = Math.max(lineNo, 0);
        lineNo = Math.min(lineNo, content.getNumberOfLines() - 1);
        return editorAdaptor.getCursorService().stickyColumnAtViewLine(lineNo);
    }

    protected abstract int getJump();

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.LINE_WISE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.NEVER;
    }
}

