/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class SentenceMotion
extends CountAwareMotion {
    public static final SentenceMotion FORWARD = new SentenceMotion(true, false);
    public static final SentenceMotion BACKWARD = new SentenceMotion(false, false);
    private static final Pattern pattern = Pattern.compile("(?<=[.?!])[)\\]\"']*\\s+(\\S|$)");
    private static final Pattern endOnSentence = Pattern.compile(".*[.?!][)\\]\"']*$");
    private boolean forward;
    private boolean includeCursor;

    private SentenceMotion(boolean forward, boolean includeCursor) {
        this.forward = forward;
        this.includeCursor = includeCursor;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        Position cursor = editorAdaptor.getPosition();
        int position = cursor.getModelOffset();
        int i = 0;
        while (i < count) {
            position = this.doIt(editorAdaptor, position);
            ++i;
        }
        return cursor.setModelOffset(position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doIt(EditorAdaptor editorAdaptor, int position) {
        TextContent modelContent = editorAdaptor.getModelContent();
        LineInformation line = modelContent.getLineInformationOfOffset(position);
        int offset = this.getSentenceBoundaryOffset(line, position, modelContent, this.includeCursor);
        while (offset == -1) {
            String lineText;
            LineInformation lineTmp;
            if (this.forward) {
                if (modelContent.getNumberOfLines() <= line.getNumber() + 1) return line.getEndOffset();
                lineTmp = line;
                line = modelContent.getLineInformation(line.getNumber() + 1);
                position = line.getBeginOffset();
                if (line.getLength() == 0 && lineTmp.getLength() != 0 || line.getLength() != 0 && lineTmp.getLength() == 0) {
                    return line.getBeginOffset();
                }
                lineText = modelContent.getText(lineTmp.getBeginOffset(), lineTmp.getLength());
                if (endOnSentence.matcher(lineText).matches()) {
                    return line.getBeginOffset();
                }
            } else {
                if (line.getNumber() <= 0) return 0;
                lineTmp = line;
                int posTmp = position;
                line = modelContent.getLineInformation(line.getNumber() - 1);
                position = line.getEndOffset();
                if (line.getLength() == 0 && lineTmp.getLength() != 0) {
                    return posTmp == lineTmp.getBeginOffset() ? line.getBeginOffset() : lineTmp.getBeginOffset();
                }
                lineText = modelContent.getText(line.getBeginOffset(), line.getLength());
                if (endOnSentence.matcher(lineText).matches() && posTmp != lineTmp.getBeginOffset()) {
                    return lineTmp.getBeginOffset();
                }
            }
            offset = this.getSentenceBoundaryOffset(line, position, modelContent, this.includeCursor);
        }
        return offset;
    }

    private int getSentenceBoundaryOffset(LineInformation line, int position, TextContent modelContent, boolean includeEnd) {
        int begin = line.getBeginOffset();
        String text = this.forward ? modelContent.getText(position, line.getEndOffset() - position) : modelContent.getText(begin, position - begin);
        ArrayList<Integer> matches = new ArrayList<Integer>();
        Matcher match = pattern.matcher(text);
        while (match.find()) {
            if (match.start(1) == text.length() && !includeEnd) continue;
            matches.add(match.start(1));
        }
        if (matches.size() > 0) {
            return this.forward ? (Integer)matches.get(0) + position : (Integer)matches.get(matches.size() - 1) + begin;
        }
        return -1;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.EXCLUSIVE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    /* synthetic */ SentenceMotion(boolean bl, boolean bl2, SentenceMotion sentenceMotion) {
        this(bl, bl2);
    }

    public static class SentenceTextObject
    extends AbstractTextObject {
        private final boolean outer;

        public SentenceTextObject(boolean outer) {
            this.outer = outer;
        }

        @Override
        public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            if (count == 0) {
                count = 1;
            }
            Position cursor = editorAdaptor.getPosition();
            int startPos = new SentenceMotion(false, true, null).destination(editorAdaptor).getModelOffset();
            int endPos = new SentenceMotion(true, true, null).destination(editorAdaptor, count).getModelOffset();
            if (!this.outer) {
                TextContent modelContent = editorAdaptor.getModelContent();
                int cursorIndex = cursor.getModelOffset();
                String text = modelContent.getText(cursorIndex, endPos - cursorIndex);
                endPos = cursorIndex + text.replaceFirst("\\s+$", "").length();
            }
            return new StartEndTextRange(cursor.setModelOffset(startPos), cursor.setModelOffset(endPos));
        }

        @Override
        public ContentType getContentType(Configuration configuration) {
            return ContentType.TEXT;
        }
    }
}

