/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchOffset;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.commandline.HighlightSearch;

public class SearchResultMotion
extends CountAwareMotion {
    public static final SearchResultMotion REPEAT = new SearchResultMotion(false);
    public static final SearchResultMotion REPEAT_REVERSED = new SearchResultMotion(true);
    public static final Motion PREVIOUS_BEGIN = new SearchResultMotion(new SearchOffset.Begin(0));
    public static final Motion NEXT_END = new SearchResultMotion(new SearchOffset.End(0));
    public static final TextObject SELECT_NEXT_MATCH = new SearchResultTextObject(false);
    public static final TextObject SELECT_PREVIOUS_MATCH = new SearchResultTextObject(true);
    private static final String NOT_FOUND_MESSAGE = "'%s' not found";
    private static final String NOT_FOUND_WRAP = "search hit %s without match for: %s";
    protected final boolean reverse;
    private Boolean forcedBackwards;
    private boolean includesTarget;
    private boolean lineWise;
    private SearchOffset fixedOffset;
    private final boolean restoreHighlighting;

    protected SearchResultMotion(boolean reverse) {
        this.reverse = reverse;
        this.restoreHighlighting = true;
    }

    protected SearchResultMotion(SearchOffset offset) {
        this.fixedOffset = offset;
        this.forcedBackwards = offset instanceof SearchOffset.Begin;
        this.reverse = false;
        this.restoreHighlighting = false;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Search search;
        if (count == 0) {
            count = 1;
        }
        if ((search = editorAdaptor.getRegisterManager().getSearch()) == null) {
            throw new CommandExecutionException("no search string given");
        }
        if (search.isRegExSearch()) {
            try {
                Pattern.compile(search.getKeyword());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new CommandExecutionException("Invalid regex search string: " + search.getKeyword());
            }
        }
        SearchOffset offset = this.fixedOffset == null ? search.getSearchOffset() : this.fixedOffset;
        SearchResult result = editorAdaptor.getLastSearchResult();
        TextContent modelContent = editorAdaptor.getModelContent();
        boolean shouldReverse = this.reverse;
        if (this.forcedBackwards != null) {
            shouldReverse = search.isBackward() ^ this.forcedBackwards;
        }
        this.includesTarget = offset instanceof SearchOffset.End;
        this.lineWise = offset.lineWise();
        Position position = result == null || !result.isFound() ? editorAdaptor.getPosition() : offset.unapply(modelContent, editorAdaptor.getPosition(), result);
        if (this.restoreHighlighting && editorAdaptor.getConfiguration().get(Options.SEARCH_HIGHLIGHT).booleanValue()) {
            HighlightSearch.HIGHLIGHT.evaluate(editorAdaptor, new LinkedList<String>());
        }
        int i = 0;
        while (i < count) {
            result = SearchResultMotion.doSearch(search, shouldReverse, editorAdaptor, position);
            editorAdaptor.setLastSearchResult(result);
            if (!result.isFound()) {
                editorAdaptor.getSearchAndReplaceService().removeHighlighting();
                if (editorAdaptor.getConfiguration().get(Options.WRAP_SCAN).booleanValue()) {
                    throw new CommandExecutionException(String.format(NOT_FOUND_MESSAGE, search.getKeyword()));
                }
                throw new CommandExecutionException(String.format(NOT_FOUND_WRAP, shouldReverse ? "TOP" : "BOTTOM", search.getKeyword()));
            }
            position = result.getStart();
            ++i;
        }
        return offset.apply(modelContent, result);
    }

    @Override
    public BorderPolicy borderPolicy() {
        if (this.lineWise) {
            return BorderPolicy.LINE_WISE;
        }
        if (this.includesTarget) {
            return BorderPolicy.INCLUSIVE;
        }
        return BorderPolicy.EXCLUSIVE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    protected static SearchResult doSearch(Search search, boolean reverse, EditorAdaptor vim, Position position) {
        if (reverse) {
            search = search.reverse();
        }
        CursorService cursorService = vim.getCursorService();
        position = search.isBackward() ? cursorService.shiftPositionForModelOffset(position.getModelOffset(), -1, true) : cursorService.shiftPositionForModelOffset(position.getModelOffset(), 1, true);
        if (search.isSelectionSearch()) {
            return VimUtils.wrapSelectionSearch(vim, search, position);
        }
        return VimUtils.wrapAroundSearch(vim, search, position);
    }

    @Override
    public boolean isJump() {
        return true;
    }

    public static class SearchResultTextObject
    extends AbstractTextObject {
        protected final boolean backwards;

        protected SearchResultTextObject(boolean backward) {
            this.backwards = backward;
        }

        @Override
        public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            Position position;
            SearchResult nextMatch;
            Search search;
            if (count == 0) {
                count = 1;
            }
            if ((search = editorAdaptor.getRegisterManager().getSearch()) == null) {
                throw new CommandExecutionException("no search string given");
            }
            if (search.isBackward() != this.backwards) {
                search = search.reverse();
            }
            if ((nextMatch = this.getCurrentMatch(editorAdaptor, search)) == null) {
                position = editorAdaptor.getPosition();
            } else {
                position = nextMatch.getLeftBound();
                --count;
            }
            int i = 0;
            while (i < count) {
                nextMatch = SearchResultMotion.doSearch(search, false, editorAdaptor, position);
                if (!nextMatch.isFound()) {
                    editorAdaptor.getSearchAndReplaceService().removeHighlighting();
                    throw new CommandExecutionException(String.format(SearchResultMotion.NOT_FOUND_MESSAGE, search.getKeyword()));
                }
                position = nextMatch.getLeftBound();
                ++i;
            }
            Position start = nextMatch.getStart();
            Position end = nextMatch.getEnd();
            if (this.backwards) {
                start = nextMatch.getEnd();
                end = nextMatch.getStart();
            }
            StartEndTextRange result = new StartEndTextRange(start, end);
            return result;
        }

        protected SearchResult getCurrentMatch(EditorAdaptor editorAdaptor, Search search) {
            SearchResult currentMatch = null;
            Search tempSearch = search;
            if (!search.isBackward()) {
                tempSearch = search.reverse();
            }
            SearchAndReplaceService searchService = editorAdaptor.getSearchAndReplaceService();
            Position position = editorAdaptor.getPosition();
            SearchResult testMatch = searchService.find(tempSearch, position);
            int currentOffset = position.getModelOffset();
            if (testMatch.isFound() && testMatch.getLeftBound().getModelOffset() <= currentOffset && testMatch.getRightBound().getModelOffset() > currentOffset) {
                currentMatch = testMatch;
            } else {
                testMatch = searchService.find(tempSearch = tempSearch.reverse(), position = testMatch.isFound() && testMatch.getRightBound().getModelOffset() <= currentOffset ? testMatch.getRightBound() : position.setModelOffset(0));
                if (testMatch.isFound() && testMatch.getLeftBound().getModelOffset() <= currentOffset && testMatch.getRightBound().getModelOffset() > currentOffset) {
                    currentMatch = testMatch;
                }
            }
            return currentMatch;
        }

        @Override
        public ContentType getContentType(Configuration configuration) {
            return ContentType.TEXT;
        }
    }
}

