/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchOffset;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.commandline.SearchCommandParser;

public class RangeSearchMotion
extends AbstractMotion {
    private String toFind;
    private Position start;
    private boolean reverse;

    public RangeSearchMotion(String toFind, Position start, boolean reverse) {
        this.toFind = toFind;
        this.start = start;
        this.reverse = reverse;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Search search = SearchCommandParser.createSearch(editorAdaptor, this.toFind, this.reverse, SearchOffset.NONE);
        SearchResult result = editorAdaptor.getSearchAndReplaceService().find(search, this.start);
        return result == null || result.getStart() == null ? null : result.getLeftBound();
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.LINE_WISE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.NEVER;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    @Override
    public Motion withCount(int count) {
        return this;
    }

    @Override
    public int getCount() {
        return 0;
    }
}

