/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class PercentOfFileMotion
extends AbstractMotion {
    protected int count;

    public PercentOfFileMotion(int count) {
        this.count = count;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.LINE_WISE;
    }

    @Override
    public Motion withCount(int count) {
        return new PercentOfFileMotion(count);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        TextContent content = editorAdaptor.getModelContent();
        if (this.count <= 0 || this.count > 100) {
            throw new CommandExecutionException("Can't jump to given percent of file, value [" + this.count + "] invalid.");
        }
        int lines = content.getNumberOfLines();
        int targetLine = (this.count * lines + 99) / 100 - 1;
        LineInformation targetLineInfo = content.getLineInformation(targetLine);
        int offset = VimUtils.getFirstNonWhiteSpaceOffset(content, targetLineInfo);
        return editorAdaptor.getCursorService().newPositionForModelOffset(offset);
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public boolean isJump() {
        return true;
    }
}

