/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;
import net.sourceforge.vrapper.vim.commands.motions.CPreProcessorMove;

public class ParenthesesMove
extends AbstractModelSideMotion {
    private static final Map<String, ParenthesesPair> PARENTHESES;
    public static final ParenthesesMove INSTANCE;
    public static final ParenthesesMove MATCH_OPEN_PAREN;
    public static final ParenthesesMove MATCH_CLOSE_PAREN;
    public static final ParenthesesMove MATCH_OPEN_CURLY;
    public static final ParenthesesMove MATCH_CLOSE_CURLY;

    static {
        HashMap<String, ParenthesesPair> op = new HashMap<String, ParenthesesPair>();
        op.put("(", new ParenthesesPair("(", ")", false));
        op.put("{", new ParenthesesPair("{", "}", false));
        op.put("[", new ParenthesesPair("[", "]", false));
        op.put("/*", new ParenthesesPair("/*", "*/", false));
        op.put(")", new ParenthesesPair("(", ")", true));
        op.put("}", new ParenthesesPair("{", "}", true));
        op.put("]", new ParenthesesPair("[", "]", true));
        op.put("*/", new ParenthesesPair("/*", "*/", true));
        PARENTHESES = Collections.unmodifiableMap(op);
        INSTANCE = new ParenthesesMove();
        MATCH_OPEN_PAREN = new ParenthesesMove(){

            @Override
            protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
                return ParenthesesMove.findMatch(offset, (ParenthesesPair)PARENTHESES.get(")"), content, count);
            }

            @Override
            public BorderPolicy borderPolicy() {
                return BorderPolicy.EXCLUSIVE;
            }
        };
        MATCH_CLOSE_PAREN = new ParenthesesMove(){

            @Override
            protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
                return ParenthesesMove.findMatch(offset, (ParenthesesPair)PARENTHESES.get("("), content, count);
            }

            @Override
            public BorderPolicy borderPolicy() {
                return BorderPolicy.EXCLUSIVE;
            }
        };
        MATCH_OPEN_CURLY = new ParenthesesMove(){

            @Override
            protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
                return ParenthesesMove.findMatch(offset, (ParenthesesPair)PARENTHESES.get("}"), content, count);
            }

            @Override
            public BorderPolicy borderPolicy() {
                return BorderPolicy.EXCLUSIVE;
            }
        };
        MATCH_CLOSE_CURLY = new ParenthesesMove(){

            @Override
            protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
                return ParenthesesMove.findMatch(offset, (ParenthesesPair)PARENTHESES.get("{"), content, count);
            }

            @Override
            public BorderPolicy borderPolicy() {
                return BorderPolicy.EXCLUSIVE;
            }
        };
    }

    @Override
    protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
        LineInformation line = content.getLineInformationOfOffset(offset);
        int startIndex = offset;
        if (offset == line.getEndOffset() && line.getLength() > 0) {
            --startIndex;
        }
        int index = startIndex;
        while (index < line.getEndOffset()) {
            String c = content.getText(index, 1);
            if (PARENTHESES.containsKey(c)) {
                return ParenthesesMove.findMatch(index, PARENTHESES.get(c), content, count);
            }
            ++index;
        }
        ParenthesesPair pair = this.getBlockComment(offset, content);
        if (pair != null) {
            return this.findBlockMatch(offset, pair, content);
        }
        if (CPreProcessorMove.containsPreProcessor(content, line, offset)) {
            return new CPreProcessorMove().destination(offset, content, count);
        }
        throw new CommandExecutionException("no parentheses to jump found");
    }

    private ParenthesesPair getBlockComment(int offset, TextContent content) {
        String underCursor = content.getText(offset, 1);
        if (underCursor.equals("*") || underCursor.equals("/")) {
            int end;
            int start = Math.max(0, offset - 1);
            String multiChar = content.getText(start, (end = Math.min(offset + 2, content.getTextLength())) - start);
            if (multiChar.length() == 2 && PARENTHESES.containsKey(multiChar)) {
                return PARENTHESES.get(multiChar);
            }
            if (multiChar.length() > 2) {
                if (PARENTHESES.containsKey(multiChar.substring(0, 2))) {
                    return PARENTHESES.get(multiChar.substring(0, 2));
                }
                if (PARENTHESES.containsKey(multiChar.substring(1, 3))) {
                    return PARENTHESES.get(multiChar.substring(1, 3));
                }
            }
        }
        return null;
    }

    private int findBlockMatch(int offset, ParenthesesPair pair, TextContent content) {
        String match;
        int indexModifier;
        int limit;
        int index = offset;
        if (pair.backwards) {
            limit = 0;
            indexModifier = -1;
            match = pair.left;
        } else {
            limit = content.getTextLength() - 1;
            indexModifier = 1;
            match = pair.right;
        }
        int matchLength = match.length();
        while (index != limit) {
            String c;
            index += indexModifier;
            try {
                c = content.getText(index, matchLength);
            }
            catch (Exception exception) {
                return offset;
            }
            if (!c.equals(match)) continue;
            return pair.backwards ? index : index + matchLength;
        }
        return offset;
    }

    private static int findMatch(int offset, ParenthesesPair pair, TextContent content, int count) {
        int indexModifier;
        int limit;
        int rightModifier;
        int leftModifier;
        int index = offset;
        int depth = count;
        if (pair.backwards) {
            leftModifier = -1;
            rightModifier = 1;
            limit = 0;
            indexModifier = -1;
        } else {
            leftModifier = 1;
            rightModifier = -1;
            limit = content.getLineInformation(content.getNumberOfLines() - 1).getEndOffset();
            indexModifier = 1;
        }
        while (index != limit && count > 0) {
            String c;
            index += indexModifier;
            try {
                c = content.getText(index, 1);
            }
            catch (Exception exception) {
                return offset;
            }
            if (c.equals(pair.right)) {
                depth += rightModifier;
            } else if (c.equals(pair.left)) {
                depth += leftModifier;
            }
            if (depth != 0) continue;
            return index;
        }
        return offset;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.INCLUSIVE;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    private static class ParenthesesPair {
        private final String left;
        private final String right;
        private final boolean backwards;

        public ParenthesesPair(String left, String right, boolean backwards) {
            this.left = left;
            this.right = right;
            this.backwards = backwards;
        }
    }
}

