/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.ViewPortInformation;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.LocalConfiguration;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class PageScrollMotion
extends CountAwareMotion {
    public static final Motion SCROLL_PGUP = new PageScrollMotion(Type.PAGE_UP);
    public static final Motion SCROLL_PGDN = new PageScrollMotion(Type.PAGE_DOWN);
    public static final Motion SCROLL_HALF_PGDN = new PageScrollMotion(Type.HALF_PAGE_DOWN);
    public static final Motion SCROLL_HALF_PGUP = new PageScrollMotion(Type.HALF_PAGE_UP);
    private final Type type;

    private PageScrollMotion(Type type) {
        this.type = type;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.LINE_WISE;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        int newModelLine;
        int scroll;
        TextContent viewContent = editorAdaptor.getViewContent();
        if (viewContent.getTextLength() == 0) {
            return null;
        }
        ViewportService viewport = editorAdaptor.getViewportService();
        ViewPortInformation view = viewport.getViewPortInformation();
        LocalConfiguration config = editorAdaptor.getConfiguration();
        if (this.type.updateScrollOption() && count != 0) {
            config.set(Options.SCROLL, count);
        }
        if ((scroll = config.get(Options.SCROLL).intValue()) == 0) {
            scroll = view.getNumberOfLines() / 2;
        }
        if (count == 0) {
            count = 1;
        }
        Position pos = editorAdaptor.getCursorService().getPosition();
        int lastChar = viewContent.getTextLength() - 1;
        int lastLineNumber = viewContent.getLineInformationOfOffset(lastChar).getNumber();
        LineInformation line = viewContent.getLineInformationOfOffset(pos.getViewOffset());
        int currenCursorLine = line.getNumber();
        int scrolloff = config.get(Options.SCROLL_OFFSET);
        int topline = this.type.calculateTopLine(view, count, scroll);
        if (topline >= lastLineNumber) {
            newModelLine = viewport.viewLine2ModelLine(lastLineNumber) + 1;
        } else {
            editorAdaptor.getViewportService().setTopLine(Math.max(0, topline));
            view = editorAdaptor.getViewportService().getViewPortInformation();
            int cursorViewLine = this.type.calculateCursorLine(view, currenCursorLine, scrolloff, scroll);
            int newCursorViewLine = Math.min(lastLineNumber + 1, Math.max(0, cursorViewLine));
            newModelLine = viewport.viewLine2ModelLine(newCursorViewLine);
        }
        Position newpos = editorAdaptor.getCursorService().stickyColumnAtModelLine(newModelLine);
        return newpos;
    }

    public static enum Type {
        PAGE_DOWN{

            @Override
            int calculateTopLine(ViewPortInformation view, int count, int scroll) {
                return view.getTopLine() + (view.getNumberOfLines() + 1) * count;
            }

            @Override
            int calculateCursorLine(ViewPortInformation view, int current, int scrolloff, int scroll) {
                return view.getTopLine() + scrolloff;
            }
        }
        ,
        PAGE_UP{

            @Override
            int calculateTopLine(ViewPortInformation view, int count, int scroll) {
                return view.getTopLine() - (view.getNumberOfLines() + 1) * count;
            }

            @Override
            int calculateCursorLine(ViewPortInformation view, int current, int scrolloff, int scroll) {
                int line = view.getBottomLine() - scrolloff;
                if (line >= current || line <= 0) {
                    return 0;
                }
                return line;
            }
        }
        ,
        HALF_PAGE_DOWN{

            @Override
            int calculateTopLine(ViewPortInformation view, int count, int scroll) {
                return view.getTopLine() + scroll;
            }

            @Override
            int calculateCursorLine(ViewPortInformation view, int current, int scrolloff, int scroll) {
                return current + scroll;
            }

            @Override
            boolean updateScrollOption() {
                return true;
            }
        }
        ,
        HALF_PAGE_UP{

            @Override
            int calculateTopLine(ViewPortInformation view, int count, int scroll) {
                return view.getTopLine() - scroll;
            }

            @Override
            int calculateCursorLine(ViewPortInformation view, int current, int scrolloff, int scroll) {
                return current - scroll;
            }

            @Override
            boolean updateScrollOption() {
                return true;
            }
        };


        abstract int calculateTopLine(ViewPortInformation var1, int var2, int var3);

        abstract int calculateCursorLine(ViewPortInformation var1, int var2, int var3, int var4);

        boolean updateScrollOption() {
            return false;
        }
    }
}

