/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.commands.motions.MoveWithBounds;

public abstract class MoveRightWithBounds
extends MoveWithBounds {
    public MoveRightWithBounds(boolean bailOff) {
        super(bailOff);
    }

    @Override
    protected int destination(int offset, TextContent content, boolean bailOff, boolean hasMoreCounts) {
        if (!bailOff && this.shouldStopAtLeftBoundingChar()) {
            ++offset;
        }
        int textLen = content.getTextLength();
        boolean lookingAtNL = false;
        block0: while (offset < textLen - 1) {
            int len = Math.min(32, textLen - offset);
            String buffer = content.getText(offset, len);
            int i = 0;
            while (i < len - 1) {
                if (this.stopsAtNewlines()) {
                    int nlSkip = VimUtils.startsWithNewLine(buffer.substring(i));
                    if (nlSkip != 0) {
                        if (lookingAtNL) {
                            return Math.min(offset, textLen);
                        }
                        offset += nlSkip - 1;
                        if ((i += nlSkip - 1) >= len - 1) continue block0;
                    }
                    boolean bl = lookingAtNL = nlSkip != 0;
                }
                if (this.atBoundary(buffer.charAt(i), buffer.charAt(i + 1))) break block0;
                ++i;
                ++offset;
            }
        }
        if (!this.shouldStopAtLeftBoundingChar() || hasMoreCounts) {
            ++offset;
        }
        return Math.min(offset, textLen);
    }
}

