/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.commands.motions.MoveWithBounds;

public abstract class MoveLeftWithBounds
extends MoveWithBounds {
    public MoveLeftWithBounds(boolean bailOff) {
        super(bailOff);
    }

    @Override
    protected int destination(int offset, TextContent content, boolean bailOff, boolean hasMoreCounts) {
        boolean haveMoved = false;
        int last = content.getTextLength() - 1;
        if (offset > last) {
            if (this.atBoundary(content.getText(last, 1).charAt(0), ' ')) {
                return last;
            }
            haveMoved = true;
            --offset;
        }
        if (!(bailOff || haveMoved || this.shouldStopAtLeftBoundingChar())) {
            --offset;
        }
        boolean lookingAtNL = false;
        block0: while (offset >= 1) {
            int len = Math.min(32, offset + 1);
            String buffer = content.getText(offset + 1 - len, len);
            int i = len - 1;
            while (i > 0) {
                if (this.atBoundary(buffer.charAt(i - 1), buffer.charAt(i))) break block0;
                if (this.stopsAtNewlines()) {
                    String prefix = buffer.substring(0, i + (this.shouldStopAtLeftBoundingChar() ? 0 : 1));
                    int nlSkip = VimUtils.endsWithNewLine(prefix);
                    if (nlSkip != 0) {
                        if (lookingAtNL) {
                            ++offset;
                            break block0;
                        }
                        i -= nlSkip - 1;
                        offset -= nlSkip - 1;
                    }
                    lookingAtNL = nlSkip != 0;
                }
                --i;
                --offset;
            }
        }
        if (this.shouldStopAtLeftBoundingChar()) {
            --offset;
        }
        return Math.max(0, offset);
    }
}

