/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.keymap.vim.OuterTextObject;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.InnerTextObject;
import net.sourceforge.vrapper.vim.commands.QuoteDelimitedText;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;

public class FindQuoteMotion
extends AbstractModelSideMotion {
    private char quote;
    private boolean findLeft;
    private int startIndex = -1;

    public FindQuoteMotion(char quote, boolean findLeft) {
        this.quote = quote;
        this.findLeft = findLeft;
    }

    public FindQuoteMotion(char quote, int startIndex) {
        this(quote, false);
        this.startIndex = startIndex;
    }

    @Override
    public int destination(int offset, TextContent content, int count) throws CommandExecutionException {
        if (this.startIndex > -1) {
            offset = this.startIndex;
        }
        LineInformation line = content.getLineInformationOfOffset(offset);
        int bol = line.getBeginOffset();
        int eol = line.getEndOffset();
        int limit = this.findLeft ? bol : eol;
        int index = this.getQuote(content, offset, limit, this.findLeft);
        if (this.findLeft && index == -1) {
            index = this.getQuote(content, offset, eol, false);
        }
        if (index == -1) {
            throw new CommandExecutionException("");
        }
        return index;
    }

    private int getQuote(TextContent content, int offset, int limit, boolean findLeft) {
        int step;
        int index = offset;
        int n = step = findLeft ? -1 : 1;
        if (findLeft && this.isQuote(content, index)) {
            if (this.getNumQuotesBeforeOffset(limit, offset, content) % 2 == 0) {
                return index;
            }
            --index;
        }
        while (!(findLeft ? index < limit : index >= limit)) {
            if (this.isQuote(content, index)) {
                return index;
            }
            index += step;
        }
        return -1;
    }

    private int getNumQuotesBeforeOffset(int bol, int limit, TextContent content) {
        int index = bol;
        int numQuotes = 0;
        while (index < limit) {
            if (this.isQuote(content, index)) {
                ++numQuotes;
            }
            ++index;
        }
        return numQuotes;
    }

    private boolean isQuote(TextContent content, int offset) {
        if (content.getText(offset, 1).charAt(0) == this.quote) {
            if (offset == 0) {
                return true;
            }
            return content.getText(offset - 1, 1).charAt(0) != '\\';
        }
        return false;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return this.findLeft ? BorderPolicy.EXCLUSIVE : BorderPolicy.INCLUSIVE;
    }

    public static class FindQuoteTextObject
    extends AbstractTextObject {
        private TextObject inQuotes;
        private TextObject includeQuotes;
        private boolean defaultInner;

        private FindQuoteTextObject(char delimiter, boolean defaultInner) {
            QuoteDelimitedText quoteDelimitedText = new QuoteDelimitedText(delimiter);
            if (defaultInner) {
                this.inQuotes = new InnerTextObject(quoteDelimitedText);
            }
            this.includeQuotes = new OuterTextObject(quoteDelimitedText);
            this.defaultInner = defaultInner;
        }

        public static TextObject inner(char delimiter) {
            return new FindQuoteTextObject(delimiter, true);
        }

        public static TextObject outer(char delimiter) {
            return new FindQuoteTextObject(delimiter, false);
        }

        @Override
        public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            if (count > 1 && this.defaultInner) {
                return this.includeQuotes.getRegion(editorAdaptor, count);
            }
            if (this.defaultInner) {
                return this.inQuotes.getRegion(editorAdaptor, count);
            }
            TextRange region = this.includeQuotes.getRegion(editorAdaptor, count);
            CursorService cursorService = editorAdaptor.getCursorService();
            TextContent content = editorAdaptor.getModelContent();
            int rightOffset = region.getRightBound().getModelOffset();
            LineInformation lineInfo = content.getLineInformationOfOffset(rightOffset);
            while (rightOffset < lineInfo.getEndOffset() && Character.isWhitespace(content.getText(rightOffset, 1).charAt(0))) {
                ++rightOffset;
            }
            Position rightPos = cursorService.newPositionForModelOffset(rightOffset);
            region = new StartEndTextRange(region.getLeftBound(), rightPos);
            return region;
        }

        @Override
        public ContentType getContentType(Configuration configuration) {
            return ContentType.TEXT;
        }
    }
}

