/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.NavigatingMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class ContinueFindingMotion
extends CountAwareMotion {
    public static final ContinueFindingMotion NORMAL = new ContinueFindingMotion(false, false);
    public static final ContinueFindingMotion REVERSE = new ContinueFindingMotion(true, false);
    public static final ContinueFindingMotion NORMAL_NAVIGATING = new ContinueFindingMotion(false, true);
    public static final ContinueFindingMotion REVERSE_NAVIGATING = new ContinueFindingMotion(true, true);
    private final boolean reverse;
    private final boolean useLastNavigatingMotion;
    private BorderPolicy borderPolicy = BorderPolicy.INCLUSIVE;

    private ContinueFindingMotion(boolean reverse, boolean useLastNavigatingMotion) {
        this.reverse = reverse;
        this.useLastNavigatingMotion = useLastNavigatingMotion;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        NavigatingMotion navigatingMotion = this.getLastNavigatingMotion(editorAdaptor);
        if (navigatingMotion == null) {
            throw new CommandExecutionException("no find to repeat");
        }
        this.borderPolicy = navigatingMotion.borderPolicy();
        Position dest = ((Motion)navigatingMotion.withCount(count)).destination(editorAdaptor);
        return dest;
    }

    protected NavigatingMotion getLastNavigatingMotion(EditorAdaptor editorAdaptor) {
        NavigatingMotion navigatingMotion = this.useLastNavigatingMotion ? editorAdaptor.getRegisterManager().getLastNavigatingMotion() : editorAdaptor.getRegisterManager().getLastFindCharMotion();
        if (navigatingMotion != null && this.reverse) {
            navigatingMotion = (NavigatingMotion)navigatingMotion.reverse();
        }
        return navigatingMotion;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return this.borderPolicy;
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }
}

