/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;

public class CPreProcessorMove
extends AbstractModelSideMotion {
    private static final Pattern preProcessorPattern = Pattern.compile("^\\s*#\\s*(if|ifdef|else|elif|endif)");
    private final String IF = "if";
    private final String IFDEF = "ifdef";
    private final String ENDIF = "endif";

    public static final boolean containsPreProcessor(TextContent content, LineInformation line, int offset) {
        String lineStr;
        Matcher matcher;
        String atCursor = content.getText(offset, 1);
        return "#\t ifdelsn".contains(atCursor) && (matcher = preProcessorPattern.matcher(lineStr = content.getText(line.getBeginOffset(), line.getLength()))).find() && offset - line.getBeginOffset() <= matcher.end();
    }

    @Override
    protected int destination(int offset, TextContent content, int count) throws CommandExecutionException {
        LineInformation line = content.getLineInformationOfOffset(offset);
        String lineStr = content.getText(line.getBeginOffset(), line.getLength());
        String word = this.getPreProcessorWord(lineStr);
        if ("endif".equals(word)) {
            return this.findIfDef(offset, content, count);
        }
        return this.findConditional(offset, content, count);
    }

    private int findIfDef(int offset, TextContent content, int count) {
        int depth = count;
        LineInformation line = content.getLineInformationOfOffset(offset);
        int lineNo = line.getNumber() - 1;
        while (lineNo > -1) {
            line = content.getLineInformation(lineNo);
            --lineNo;
            if (!CPreProcessorMove.containsPreProcessor(content, line, line.getBeginOffset())) continue;
            String lineStr = content.getText(line.getBeginOffset(), line.getLength());
            String word = this.getPreProcessorWord(lineStr);
            if ("endif".equals(word)) {
                ++depth;
            } else if ("if".equals(word) || "ifdef".equals(word)) {
                --depth;
            }
            if (depth != 0) continue;
            return lineStr.indexOf(35) + line.getBeginOffset();
        }
        return offset;
    }

    private int findConditional(int offset, TextContent content, int count) {
        int depth = count;
        LineInformation line = content.getLineInformationOfOffset(offset);
        int lineNo = line.getNumber() + 1;
        int totalLines = content.getNumberOfLines();
        while (lineNo < totalLines) {
            line = content.getLineInformation(lineNo);
            ++lineNo;
            if (line.getLength() == 0 || !CPreProcessorMove.containsPreProcessor(content, line, line.getBeginOffset())) continue;
            String lineStr = content.getText(line.getBeginOffset(), line.getLength());
            String word = this.getPreProcessorWord(lineStr);
            if ("if".equals(word) || "ifdef".equals(word)) {
                ++depth;
                continue;
            }
            if (depth == 1) {
                return lineStr.indexOf(35) + line.getBeginOffset();
            }
            if (!"endif".equals(word)) continue;
            --depth;
        }
        return offset;
    }

    private String getPreProcessorWord(String line) {
        Matcher matcher = preProcessorPattern.matcher(line);
        matcher.find();
        return matcher.group(1);
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.INCLUSIVE;
    }
}

