/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands.motions;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.BlockWiseSelectionArea;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.AbstractMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class BlockSelectionMotion
extends AbstractMotion {
    public static final BlockSelectionMotion COLUMN_START = new BlockSelectionMotion(true);
    public static final BlockSelectionMotion COLUMN_END = new BlockSelectionMotion(false);
    private final boolean gotoStart;

    private BlockSelectionMotion(boolean gotoStart) {
        this.gotoStart = gotoStart;
    }

    @Override
    public BorderPolicy borderPolicy() {
        return BorderPolicy.EXCLUSIVE;
    }

    @Override
    public Motion withCount(int count) {
        return this;
    }

    @Override
    public Position destination(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Selection selection = editorAdaptor.getSelection();
        if (selection == null) {
            throw new CommandExecutionException("BlockSelectionMotion must have a selection!");
        }
        BlockWiseSelectionArea lastSel = (BlockWiseSelectionArea)editorAdaptor.getRegisterManager().getLastActiveSelectionArea();
        CursorService cs = editorAdaptor.getCursorService();
        TextContent mc = editorAdaptor.getModelContent();
        TextRange tr = lastSel.getRegion(editorAdaptor, 0);
        BlockWiseSelection.TextBlock tb = BlockWiseSelection.getTextBlock(tr.getStart(), tr.getEnd(), mc, cs);
        if (this.gotoStart) {
            return cs.getPositionByVisualOffset(tb.startLine, tb.startVisualOffset);
        }
        Position pos = null;
        if (!lastSel.isUntilEOL()) {
            pos = cs.getPositionByVisualOffset(tb.startLine, tb.endVisualOffset);
        }
        LineInformation line = mc.getLineInformation(tb.startLine);
        if (pos != null && pos.getModelOffset() < line.getEndOffset()) {
            return pos.addModelOffset(1);
        }
        return cs.newPositionForModelOffset(line.getEndOffset());
    }

    @Override
    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.NEVER;
    }

    @Override
    public boolean isJump() {
        return false;
    }
}

