/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.Set;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LineWiseOperation;
import net.sourceforge.vrapper.vim.commands.SimpleTextOperation;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.RegisterManager;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public class YankOperation
extends SimpleTextOperation
implements LineWiseOperation {
    public static final YankOperation INSTANCE = new YankOperation(null);
    private final String register;
    private final boolean updateCursor;

    YankOperation(String register) {
        this(register, true);
    }

    YankOperation(String register, boolean updateCursor) {
        this.register = register;
        this.updateCursor = updateCursor;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, TextRange region, ContentType contentType) {
        RegisterManager registerManager = editorAdaptor.getRegisterManager();
        if (this.register != null) {
            registerManager.setActiveRegister(this.register);
        }
        YankOperation.doIt(editorAdaptor, region, contentType, true, this.updateCursor);
        Set<String> clipboardOption = editorAdaptor.getConfiguration().get(Options.CLIPBOARD);
        if (clipboardOption.contains("unnamed")) {
            Register selReg = registerManager.getRegister("*");
            selReg.setContent(registerManager.getActiveRegister().getContent());
        }
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        this.execute(editorAdaptor, lineRange.getRegion(editorAdaptor, 0), ContentType.LINES);
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public TextOperation repetition() {
        return null;
    }

    public static void doIt(EditorAdaptor editorAdaptor, TextRange range, ContentType contentType, boolean setLastYank) {
        YankOperation.doIt(editorAdaptor, range, contentType, setLastYank, true);
    }

    public static void doIt(EditorAdaptor editorAdaptor, TextRange range, ContentType contentType, boolean setLastYank, boolean updateCursor) {
        if (range == null) {
            return;
        }
        String text = editorAdaptor.getModelContent().getText(range.getLeftBound().getModelOffset(), range.getModelLength());
        if (!(contentType != ContentType.LINES || text.length() != 0 && VimUtils.isNewLine(text.substring(text.length() - 1)))) {
            text = String.valueOf(text) + editorAdaptor.getConfiguration().getNewLine();
        }
        CursorService cur = editorAdaptor.getCursorService();
        cur.setMark("[", range.getLeftBound());
        int exclude = VimUtils.endsWithNewLine(text);
        if (exclude == 0) {
            exclude = 1;
        }
        cur.setMark("]", cur.shiftPositionForModelOffset(range.getRightBound().getModelOffset(), -exclude, true));
        RegisterContent content = new StringRegisterContent(contentType, text);
        if (contentType == ContentType.LINES && "normal mode".equals(editorAdaptor.getCurrentModeName())) {
            int lineNo = editorAdaptor.getModelContent().getLineInformationOfOffset(range.getLeftBound().getModelOffset()).getNumber();
            Position stickyPosition = editorAdaptor.getCursorService().stickyColumnAtModelLine(lineNo);
            if (updateCursor) {
                editorAdaptor.getCursorService().setPosition(stickyPosition, StickyColumnPolicy.ON_CHANGE);
            }
        } else if (contentType == ContentType.TEXT_RECTANGLE) {
            content = BlockWiseSelection.getTextBlockContent(editorAdaptor, range);
            editorAdaptor.setPosition(range.getLeftBound(), StickyColumnPolicy.ON_CHANGE);
        } else {
            Position cursor = editorAdaptor.getCursorService().getPosition();
            Position newPos = range.getLeftBound();
            if (cursor.getModelOffset() != newPos.getModelOffset()) {
                cur.setPosition(newPos, StickyColumnPolicy.ON_CHANGE);
            }
        }
        RegisterManager registerManager = editorAdaptor.getRegisterManager();
        registerManager.getActiveRegister().setContent(content);
        if (setLastYank && registerManager.isDefaultRegisterActive()) {
            registerManager.setLastYank(content);
        }
    }
}

