/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DelimitedText;

public class XmlTagDelimitedText
implements DelimitedText {
    private static final String XML_TAG_REGEX = "(?:(<(?!%|!)(<(?=%)|(?<=%)>|[^<]){0,1000}(?<!%|/)>))";
    private static final Pattern tagPattern = Pattern.compile("(?:(<(?!%|!)(<(?=%)|(?<=%)>|[^<]){0,1000}(?<!%|/)>))", 32);
    private static final String XML_NAME_REGEX = "</?([^\\s]*).*?>";
    private static final Pattern tagNamePattern = Pattern.compile("</?([^\\s]*).*?>", 32);
    private TextRange endTag;
    private TextRange openTag;

    @Override
    public TextRange leftDelimiter(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        this.calculateOpenAndCloseTag(offset, editorAdaptor, count);
        return this.openTag;
    }

    @Override
    public TextRange rightDelimiter(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        this.calculateOpenAndCloseTag(offset, editorAdaptor, count);
        return this.endTag;
    }

    private void calculateOpenAndCloseTag(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        Position beginningPosition = this.getStartingPosition(offset, editorAdaptor);
        Position startOpenSearch = beginningPosition.addModelOffset(1);
        Position startCloseSearch = beginningPosition.addModelOffset(-1);
        int i = 0;
        while (i < count) {
            this.openTag = this.getUnbalancedOpenTag(startOpenSearch, editorAdaptor);
            String tagName = this.getTagName(this.openTag, editorAdaptor);
            this.endTag = this.getUnbalancedClosingTag(startCloseSearch, tagName, editorAdaptor);
            startOpenSearch = this.openTag.getLeftBound();
            startCloseSearch = this.endTag.getRightBound();
            ++i;
        }
    }

    private Position getStartingPosition(int offset, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Position beginningPosition = editorAdaptor.getCursorService().newPositionForModelOffset(offset);
        if (this.insideIndentation(beginningPosition, editorAdaptor)) {
            TextRange tag = this.findNextTag(beginningPosition, editorAdaptor);
            String contents = editorAdaptor.getModelContent().getText(tag);
            beginningPosition = this.isCloseTag(contents) ? tag.getLeftBound() : tag.getRightBound();
        } else {
            if (this.insideOpeningTag(beginningPosition, editorAdaptor)) {
                while (this.characterAt(beginningPosition, editorAdaptor) != '>') {
                    beginningPosition = beginningPosition.addModelOffset(1);
                }
            }
            if (this.insideClosingTag(beginningPosition, editorAdaptor)) {
                while (this.characterAt(beginningPosition, editorAdaptor) != '<') {
                    beginningPosition = beginningPosition.addModelOffset(-1);
                }
            }
        }
        return beginningPosition;
    }

    private boolean insideIndentation(Position position, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        boolean isIndentation = false;
        if (Character.isWhitespace(this.characterAt(position, editorAdaptor))) {
            TextRange nextTag;
            int tagColumn;
            LineInformation currentLine = editorAdaptor.getModelContent().getLineInformationOfOffset(position.getModelOffset());
            int column = position.getModelOffset() - currentLine.getBeginOffset();
            String lineText = editorAdaptor.getModelContent().getText(currentLine.getBeginOffset(), currentLine.getLength());
            if (lineText.length() == 0 || column < 0 || column >= lineText.length()) {
                return false;
            }
            int i = column;
            while (i >= 0 && Character.isWhitespace(lineText.charAt(i))) {
                --i;
            }
            if (i < 0 && (tagColumn = (nextTag = this.findNextTag(position, editorAdaptor)).getLeftBound().getModelOffset() - currentLine.getBeginOffset()) < lineText.length()) {
                i = column;
                while (i < tagColumn && Character.isWhitespace(lineText.charAt(i))) {
                    ++i;
                }
                isIndentation = i == tagColumn;
            }
        }
        return isIndentation;
    }

    private boolean insideOpeningTag(Position position, EditorAdaptor editorAdaptor) {
        return this.insideTag(position, editorAdaptor, true);
    }

    private boolean insideClosingTag(Position position, EditorAdaptor editorAdaptor) {
        return this.insideTag(position, editorAdaptor, false);
    }

    private boolean insideTag(Position position, EditorAdaptor editorAdaptor, boolean openingTag) {
        return this.toRightOfTagOpener(position, editorAdaptor, openingTag) && this.toLeftOfTagCloser(position, editorAdaptor);
    }

    private boolean toLeftOfTagCloser(Position position, EditorAdaptor editorAdaptor) {
        while (this.characterAt(position, editorAdaptor) != '>') {
            if ((position = position.addModelOffset(1)).getModelOffset() >= editorAdaptor.getModelContent().getTextLength()) {
                return false;
            }
            if (this.characterAt(position, editorAdaptor) != '<') continue;
            return false;
        }
        return true;
    }

    private boolean toRightOfTagOpener(Position position, EditorAdaptor editorAdaptor, boolean openingTag) {
        while (this.characterAt(position, editorAdaptor) != '<') {
            if ((position = position.addModelOffset(-1)).getModelOffset() < 0) {
                return false;
            }
            if (this.characterAt(position, editorAdaptor) != '>') continue;
            return false;
        }
        position = position.addModelOffset(1);
        if (openingTag) {
            return this.characterAt(position, editorAdaptor) != '/';
        }
        return this.characterAt(position, editorAdaptor) == '/';
    }

    private char characterAt(Position position, EditorAdaptor editorAdaptor) {
        return editorAdaptor.getModelContent().getText(position.getModelOffset(), 1).charAt(0);
    }

    public TextRange getUnbalancedOpenTag(Position start, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Stack<String> closeTags = new Stack<String>();
        while (true) {
            String tagName;
            TextRange tag = this.findPreviousTag(start, editorAdaptor);
            String contents = editorAdaptor.getModelContent().getText(tag);
            start = tag.getLeftBound();
            if (this.isCloseTag(contents)) {
                tagName = this.getTagName(tag, editorAdaptor);
                closeTags.push(tagName);
                continue;
            }
            tagName = this.getTagName(tag, editorAdaptor);
            if (closeTags.empty()) {
                return tag;
            }
            if (!((String)closeTags.peek()).equals(tagName)) continue;
            closeTags.pop();
        }
    }

    private boolean isCloseTag(String contents) {
        return contents.startsWith("</");
    }

    public TextRange getUnbalancedClosingTag(Position start, String toFindTagName, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Stack<String> openTags = new Stack<String>();
        while (true) {
            String tagName;
            TextRange tag = this.findNextTag(start, editorAdaptor);
            String contents = editorAdaptor.getModelContent().getText(tag);
            start = tag.getRightBound();
            if (this.isCloseTag(contents)) {
                tagName = this.getTagName(tag, editorAdaptor);
                if (tagName.equals(toFindTagName) && openTags.empty()) {
                    return tag;
                }
                if (!tagName.equals(toFindTagName)) continue;
                openTags.pop();
                continue;
            }
            tagName = this.getTagName(tag, editorAdaptor);
            if (!tagName.equals(toFindTagName)) continue;
            openTags.push(tagName);
        }
    }

    private TextRange findNextTag(Position start, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        TextContent content = editorAdaptor.getModelContent();
        int startPos = start.getModelOffset();
        String textAfterStartPos = this.getText(editorAdaptor, startPos, content.getTextLength());
        return this.rangeForFirstXmlTagWithOffset(editorAdaptor, textAfterStartPos, startPos);
    }

    private TextRange rangeForFirstXmlTagWithOffset(EditorAdaptor editorAdaptor, String text, int startPos) throws CommandExecutionException {
        Matcher matcher = tagPattern.matcher(text);
        if (matcher.find()) {
            int matchStart = matcher.start() + startPos;
            int matchEnd = matcher.end() + startPos;
            return this.getRange(editorAdaptor, matchStart, matchEnd);
        }
        throw new CommandExecutionException("The cursor is not within an XML tag");
    }

    private TextRange findPreviousTag(Position start, EditorAdaptor editorAdaptor) throws CommandExecutionException {
        int startPos = start.getModelOffset();
        String textBeforeStartPos = this.getText(editorAdaptor, 0, startPos);
        return this.rangeForLastXmlTag(editorAdaptor, textBeforeStartPos);
    }

    private TextRange rangeForLastXmlTag(EditorAdaptor editorAdaptor, String text) throws CommandExecutionException {
        Matcher matcher = tagPattern.matcher(text);
        TextRange range = null;
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            range = this.getRange(editorAdaptor, matchStart, matchEnd);
        }
        if (range != null) {
            return range;
        }
        throw new CommandExecutionException("The cursor is not within an XML tag");
    }

    private String getText(EditorAdaptor editorAdaptor, int from, int to) {
        return editorAdaptor.getModelContent().getText(from, to - from);
    }

    private String getTagName(TextRange tagRange, EditorAdaptor editorAdaptor) {
        String contents = editorAdaptor.getModelContent().getText(tagRange);
        Matcher matcher = tagNamePattern.matcher(contents);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private TextRange getRange(EditorAdaptor editorAdaptor, int start, int end) {
        CursorService cursorService = editorAdaptor.getCursorService();
        Position matchBegin = cursorService.newPositionForModelOffset(start);
        Position matchEnd = cursorService.newPositionForModelOffset(end);
        return new StartEndTextRange(matchBegin, matchEnd);
    }
}

