/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractVisualMotionCommand;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.Motion;

public class VisualMotionCommand
extends AbstractVisualMotionCommand {
    public VisualMotionCommand(Motion motion) {
        super(motion);
    }

    @Override
    protected void extendSelection(EditorAdaptor editorAdaptor, Selection oldSelection, int motionCount) {
        Selection newSelection;
        Position from = oldSelection.getFrom();
        Position newTo = editorAdaptor.getPosition();
        Position oldTo = oldSelection.getTo();
        boolean selReversed = from.compareTo(newTo) > 0;
        boolean selShiftsToRight = newTo.compareTo(oldTo) > 0;
        boolean selGrowsToRight = selShiftsToRight && !selReversed;
        BorderPolicy motionBorderPolicy = this.getMotion(motionCount).borderPolicy();
        String selectionMode = editorAdaptor.getConfiguration().get(Options.SELECTION);
        if ("exclusive".equals(selectionMode)) {
            if (motionBorderPolicy == BorderPolicy.INCLUSIVE && selGrowsToRight) {
                newTo = VimUtils.safeAddModelOffset(editorAdaptor, newTo, 1, true);
            }
            newSelection = oldSelection.reset(editorAdaptor, from, newTo);
        } else if ("inclusive".equals(selectionMode)) {
            newSelection = oldSelection.reset(editorAdaptor, from, newTo);
        } else {
            VrapperLog.error("Unhandled 'selection' value " + selectionMode);
            newSelection = null;
        }
        editorAdaptor.setSelection(newSelection);
    }
}

