/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.Buffer;
import net.sourceforge.vrapper.platform.BufferAndTabService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;

public class SwitchBufferCommand
extends CountAwareCommand {
    public static final Command INSTANCE = new SwitchBufferCommand();
    public static final Pattern BUFFER_CMD_PATTERN = Pattern.compile("(b(?:u(?:f(?:f(?:er?)?)?)?)?)");
    public static final Pattern BUFFER_CMD_GLUED_ARG_PATTERN = Pattern.compile("^!?(?:%|#|([0-9]+))$");
    public String targetBuffer;

    public SwitchBufferCommand() {
        this.targetBuffer = "#";
    }

    public SwitchBufferCommand(String buffer) {
        this.targetBuffer = buffer;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        BufferAndTabService batService = editorAdaptor.getBufferAndTabService();
        if ("%".equals(this.targetBuffer)) {
            return;
        }
        if ((count < 0 || count == 0) && "#".equals(this.targetBuffer)) {
            Buffer previousBuffer = batService.getPreviousBuffer();
            batService.switchBuffer(previousBuffer);
        } else {
            Integer targetBufferId;
            if (count < 0) {
                throw new CommandExecutionException("Invalid count specified: " + count);
            }
            if (count > 0 && "#".equals(this.targetBuffer)) {
                targetBufferId = count;
            } else {
                try {
                    targetBufferId = Integer.parseInt(this.targetBuffer);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CommandExecutionException(String.valueOf(this.targetBuffer) + " is not a valid number!");
                }
            }
            int i = 0;
            List<Buffer> buffers = batService.getBuffers();
            while (i < buffers.size() && !targetBufferId.equals(buffers.get(i).getId())) {
                ++i;
            }
            if (i == buffers.size()) {
                throw new CommandExecutionException("No buffer found with id " + targetBufferId);
            }
            Buffer buffer = buffers.get(i);
            batService.switchBuffer(buffer);
        }
    }

    @Override
    public CountAwareCommand repetition() {
        return null;
    }
}

