/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractModelSideCommand;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SimpleTextOperation;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class SwapCaseCommand
extends AbstractModelSideCommand {
    public static final SwapCaseCommand INSTANCE = new SwapCaseCommand();
    public static final SwapCaseCommand VISUAL_INSTANCE = new SwapCaseCommand(){

        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) {
            editorAdaptor.rememberLastActiveSelection();
            Selection selection = editorAdaptor.getSelection();
            try {
                TextRange range = selection.getRegion(editorAdaptor, 0);
                SwapCaseCommand.swapCase(editorAdaptor.getModelContent(), range.getLeftBound().getModelOffset(), range.getModelLength());
                editorAdaptor.getCursorService().setPosition(range.getLeftBound(), StickyColumnPolicy.ON_CHANGE);
                LeaveVisualModeCommand.doIt(editorAdaptor);
            }
            catch (CommandExecutionException e) {
                editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
        }
    };
    public static final SwapCaseCommand VISUALBLOCK_INSTANCE = new SwapCaseCommand(){

        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) {
            editorAdaptor.rememberLastActiveSelection();
            TextContent textContent = editorAdaptor.getModelContent();
            Selection selection = editorAdaptor.getSelection();
            Position selectionStart = selection.getFrom();
            Position selectionEnd = selection.getTo();
            CursorService cursorService = editorAdaptor.getCursorService();
            try {
                HistoryService history = editorAdaptor.getHistory();
                history.beginCompoundChange();
                history.lock("block-action");
                BlockWiseSelection.TextBlock textBlock = BlockWiseSelection.getTextBlock(selectionStart, selectionEnd, textContent, cursorService);
                int line = textBlock.startLine;
                while (line <= textBlock.endLine) {
                    Position start = cursorService.getPositionByVisualOffset(line, textBlock.startVisualOffset);
                    if (start != null) {
                        int startOfs = start.getModelOffset();
                        Position end = cursorService.getPositionByVisualOffset(line, textBlock.endVisualOffset);
                        int endOfs = end == null ? textContent.getLineInformation(line).getEndOffset() : end.addModelOffset(1).getModelOffset();
                        SwapCaseCommand.swapCase(textContent, startOfs, endOfs - startOfs);
                    }
                    ++line;
                }
                cursorService.setPosition(cursorService.getPositionByVisualOffset(textBlock.startLine, textBlock.startVisualOffset), StickyColumnPolicy.ON_CHANGE);
                history.unlock("block-action");
                history.endCompoundChange();
                LeaveVisualModeCommand.doIt(editorAdaptor);
            }
            catch (CommandExecutionException e) {
                editorAdaptor.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
        }
    };
    public static final SimpleTextOperation TEXT_OBJECT_INSTANCE = new SimpleTextOperation(){

        @Override
        public TextOperation repetition() {
            return this;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor, TextRange region, ContentType contentType) throws CommandExecutionException {
            SwapCaseCommand.swapCase(editorAdaptor.getModelContent(), region.getLeftBound().getModelOffset(), region.getModelLength());
        }
    };

    private SwapCaseCommand() {
    }

    @Override
    protected int execute(TextContent content, int offset, int count) {
        LineInformation line = content.getLineInformationOfOffset(offset);
        int end = Math.min(offset + count, line.getEndOffset());
        int length = end - offset;
        SwapCaseCommand.swapCase(content, offset, length);
        return end;
    }

    public static void swapCase(TextContent content, int start, int length) {
        String text = content.getText(start, length);
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            c = Character.isUpperCase(c) ? Character.toLowerCase(c) : Character.toUpperCase(c);
            s.append(c);
            ++i;
        }
        content.replace(start, length, s.toString());
    }

    /* synthetic */ SwapCaseCommand(SwapCaseCommand swapCaseCommand) {
        this();
    }
}

