/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.NumericStringComparator;
import net.sourceforge.vrapper.utils.PatternSortComparator;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class SortOperation
extends AbstractLinewiseOperation {
    private static final String REVERSED_FLAG = "!";
    private static final String NUMERIC_FLAG = "n";
    private static final String IGNORE_CASE_FLAG = "i";
    private static final String BINARY_FLAG = "b";
    private static final String OCTAL_FLAG = "o";
    private static final String HEX_FLAG = "x";
    private static final String UNIQUE_FLAG = "u";
    private static final String USE_PATTERN_R = "r";
    private boolean reversed = false;
    private boolean numeric = false;
    private boolean ignoreCase = false;
    private boolean binary = false;
    private boolean hex = false;
    private boolean octal = false;
    private boolean unique = false;
    private boolean usePattern = false;
    private boolean usePatternR = false;
    private String pattern = null;

    public SortOperation(String commandStr) {
        String[] options;
        this.pattern = this.parsePattern(commandStr);
        if (this.pattern != null) {
            commandStr = commandStr.replace(this.pattern, "");
            this.usePattern = true;
            this.pattern = this.pattern.substring(1, this.pattern.length() - 1);
        }
        String[] stringArray = options = commandStr.split("");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option != null && !option.trim().isEmpty()) {
                if (option.equalsIgnoreCase(REVERSED_FLAG)) {
                    this.reversed = true;
                } else if (option.equalsIgnoreCase(NUMERIC_FLAG)) {
                    this.numeric = true;
                } else if (option.equalsIgnoreCase(IGNORE_CASE_FLAG)) {
                    this.ignoreCase = true;
                } else if (option.equalsIgnoreCase(BINARY_FLAG)) {
                    this.binary = true;
                } else if (option.equalsIgnoreCase(OCTAL_FLAG)) {
                    this.octal = true;
                } else if (option.equalsIgnoreCase(HEX_FLAG)) {
                    this.hex = true;
                } else if (option.equalsIgnoreCase(UNIQUE_FLAG)) {
                    this.unique = true;
                } else if (this.usePattern && option.equalsIgnoreCase(USE_PATTERN_R)) {
                    this.usePatternR = true;
                }
            }
            ++n2;
        }
    }

    private String parsePattern(String command) {
        char[] chars = command.toCharArray();
        int i = 0;
        while (i < chars.length) {
            String c = String.valueOf(chars[i]);
            if (!c.trim().isEmpty() && VimUtils.isPatternDelimiter(c)) {
                int match = command.indexOf(c.charAt(0), i + 1);
                if (match == -1) {
                    return null;
                }
                return command.substring(i, match + 1);
            }
            ++i;
        }
        return null;
    }

    private boolean hasNumber(String str, int offset) {
        char[] strArr;
        int radix = 10;
        if (this.binary) {
            radix = 2;
        } else if (this.octal) {
            radix = 8;
        } else if (this.hex) {
            radix = 16;
        }
        if (offset > 0) {
            str = str.substring(offset);
        }
        char[] cArray = strArr = str.toCharArray();
        int n = strArr.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.digit(c, radix) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        try {
            TextContent content = editorAdaptor.getModelContent();
            LineInformation startLine = content.getLineInformation(lineRange.getStartLine());
            LineInformation endLine = content.getLineInformation(lineRange.getEndLine());
            int length = lineRange.getModelLength();
            if (startLine.getNumber() < endLine.getNumber()) {
                this.doIt(editorAdaptor, startLine, endLine, length);
            }
        }
        catch (Exception e) {
            throw new CommandExecutionException("sort failed: " + e.getMessage());
        }
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.entireFile(editorAdaptor);
    }

    public void doIt(EditorAdaptor editorAdaptor, LineInformation startLine, LineInformation endLine, int totalLengthOfRange) throws Exception {
        String newline = editorAdaptor.getConfiguration().getNewLine();
        TextContent content = editorAdaptor.getModelContent();
        int totalLinesInEditor = content.getNumberOfLines();
        ArrayList<String> editorContentList = new ArrayList<String>();
        Comparator<String> comp = null;
        LineInformation line = null;
        int i = startLine.getNumber();
        while (i <= endLine.getNumber()) {
            line = content.getLineInformation(i);
            String lineStr = content.getText(line.getBeginOffset(), line.getLength());
            editorContentList.add(lineStr);
            ++i;
        }
        if (this.unique) {
            TreeSet<String> set = this.ignoreCase ? new TreeSet(String.CASE_INSENSITIVE_ORDER) : new TreeSet<String>();
            set.addAll(editorContentList);
            editorContentList = new ArrayList(set);
            totalLinesInEditor = editorContentList.size();
        }
        ArrayList<String> candidateList = editorContentList;
        ArrayList<Integer> candidateOffsetList = new ArrayList<Integer>();
        ArrayList<String> nonCandidateList = new ArrayList<String>();
        if (this.usePattern) {
            int i2 = 0;
            while (i2 < candidateList.size()) {
                String candidate = (String)candidateList.get(i2);
                if (candidate.contains(this.pattern)) {
                    candidateOffsetList.add(this.usePatternR ? candidate.indexOf(this.pattern) : candidate.indexOf(this.pattern) + this.pattern.length());
                } else {
                    candidateList.remove(i2);
                    --i2;
                    nonCandidateList.add(candidate);
                }
                ++i2;
            }
            comp = new PatternSortComparator(this.pattern, this.usePatternR);
        }
        if (this.numeric || this.binary || this.octal || this.hex) {
            String newLine = editorAdaptor.getConfiguration().getNewLine();
            comp = new NumericStringComparator(newLine, this.binary, this.octal, this.hex, this.pattern, this.usePatternR);
            int i3 = 0;
            while (i3 < candidateList.size()) {
                int candidateOffset;
                String candidate = (String)candidateList.get(i3);
                int n = candidateOffset = candidateOffsetList.size() > i3 ? (Integer)candidateOffsetList.get(i3) : -1;
                if (!this.hasNumber(candidate, candidateOffset)) {
                    candidateList.remove(candidate);
                    --i3;
                    nonCandidateList.add(candidate);
                }
                ++i3;
            }
        } else if (this.ignoreCase) {
            comp = String.CASE_INSENSITIVE_ORDER;
        }
        if (comp == null) {
            Collections.sort(candidateList);
        } else {
            Collections.sort(candidateList, comp);
        }
        editorContentList = new ArrayList(nonCandidateList);
        editorContentList.addAll(candidateList);
        if (this.reversed) {
            Collections.reverse(editorContentList);
        }
        StringBuilder replacementText = new StringBuilder();
        int count = startLine.getNumber();
        for (String editorLine : editorContentList) {
            if (count != totalLinesInEditor - 1) {
                editorLine = String.valueOf(editorLine) + newline;
            }
            ++count;
            replacementText.append(editorLine);
        }
        editorAdaptor.getModelContent().replace(startLine.getBeginOffset(), totalLengthOfRange, replacementText.toString());
        editorAdaptor.setPosition(editorAdaptor.getCursorService().newPositionForModelOffset(startLine.getBeginOffset()), StickyColumnPolicy.ON_CHANGE);
    }

    @Override
    public TextOperation repetition() {
        return null;
    }
}

