/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.DelimitedText;
import net.sourceforge.vrapper.vim.commands.motions.AbstractModelSideMotion;
import net.sourceforge.vrapper.vim.commands.motions.BailOffMotion;
import net.sourceforge.vrapper.vim.commands.motions.FindBalancedMotion;

public class SimpleDelimitedText
implements DelimitedText {
    private AbstractModelSideMotion leftMotion;
    private AbstractModelSideMotion rightMotion;

    public SimpleDelimitedText(char leftDelim, char rightDelim) {
        this.leftMotion = new BailOffMotion(leftDelim, new FindBalancedMotion(leftDelim, rightDelim, true, true, false));
        this.rightMotion = new BailOffMotion(rightDelim, new FindBalancedMotion(rightDelim, leftDelim, true, false, false));
    }

    public SimpleDelimitedText(char delimiter) {
        this.leftMotion = new FindBalancedMotion(delimiter, '\u0000', true, true, false);
        this.rightMotion = new BailOffMotion(delimiter, new FindBalancedMotion(delimiter, '\u0000', true, false, false));
    }

    @Override
    public TextRange leftDelimiter(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Position left = this.leftMotion.destination(offset, editorAdaptor, count);
        Position leftDelim = VimUtils.fixLeftDelimiter(editorAdaptor.getModelContent(), editorAdaptor.getCursorService(), left);
        return new StartEndTextRange(left, leftDelim);
    }

    @Override
    public TextRange rightDelimiter(int offset, EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Position right = this.rightMotion.destination(offset, editorAdaptor, count);
        Position rightDelim = VimUtils.fixRightDelimiter(editorAdaptor.getModelContent(), editorAdaptor.getCursorService(), right);
        return new StartEndTextRange(rightDelim, right.addModelOffset(1));
    }
}

