/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SelectionArea;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.DummyTextObject;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.RegisterManager;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;

public class SelectionBasedTextOperationCommand
extends CountAwareCommand {
    protected final TextOperation command;
    protected final boolean changeMode;

    public SelectionBasedTextOperationCommand(TextOperation command) {
        this(command, true);
    }

    protected SelectionBasedTextOperationCommand(TextOperation command, boolean leavesVisualMode) {
        this.command = command;
        this.changeMode = leavesVisualMode;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        editorAdaptor.rememberLastActiveSelection();
        TextContent textContent = editorAdaptor.getModelContent();
        Selection selection = editorAdaptor.getSelection();
        try {
            if (selection.getContentType(editorAdaptor.getConfiguration()) == ContentType.TEXT_RECTANGLE) {
                TextRange blockRange = selection.getRegion(editorAdaptor, 0);
                editorAdaptor.setSelection(null);
                SelectionBasedTextOperationCommand.doIt(editorAdaptor, count, this.command, textContent, blockRange, this.changeMode);
            } else {
                this.command.execute(editorAdaptor, count, selection);
            }
        }
        finally {
            if (this.changeMode) {
                LeaveVisualModeCommand.doIt(editorAdaptor);
            }
        }
    }

    public static void doIt(EditorAdaptor editorAdaptor, int count, TextOperation command, TextContent textContent, TextRange blockRange, boolean changeMode) throws CommandExecutionException {
        Position runEnd;
        CursorService cursorService = editorAdaptor.getCursorService();
        BlockWiseSelection.TextBlock textBlock = BlockWiseSelection.getTextBlock(blockRange.getStart(), blockRange.getEnd(), editorAdaptor.getModelContent(), cursorService);
        Position runStart = cursorService.getPositionByVisualOffset(textBlock.startLine, textBlock.startVisualOffset);
        LineInformation lineInfo = textContent.getLineInformation(textBlock.startLine);
        if (runStart == null) {
            runStart = cursorService.newPositionForModelOffset(lineInfo.getBeginOffset());
        }
        runEnd = (runEnd = cursorService.getPositionByVisualOffset(textBlock.startLine, textBlock.endVisualOffset)) == null ? cursorService.newPositionForModelOffset(lineInfo.getEndOffset()) : runEnd.addModelOffset(1);
        DummyTextObject firstLine = new DummyTextObject(new StartEndTextRange(runStart, runEnd));
        HistoryService history = editorAdaptor.getHistory();
        RegisterManager registerManager = editorAdaptor.getRegisterManager();
        Register activeRegister = registerManager.getActiveRegister();
        TextBlockRegisterContent yankContent = BlockWiseSelection.getTextBlockContent(editorAdaptor, blockRange);
        history.unlock();
        try {
            history.beginCompoundChange();
            history.lock("block-action");
            command.execute(editorAdaptor, count, firstLine);
            if (changeMode) {
                registerManager.setActiveRegister(activeRegister);
                BlockwiseRepeatCommand.doIt(editorAdaptor, command, count, textBlock);
                activeRegister.setContent(yankContent);
            }
        }
        finally {
            if (changeMode) {
                history.unlock("block-action");
                history.endCompoundChange();
            }
        }
    }

    @Override
    public CountAwareCommand repetition() {
        TextOperation wrappedRepetition = this.command.repetition();
        if (wrappedRepetition != null) {
            return new Repetition(wrappedRepetition, this.changeMode);
        }
        return null;
    }

    public static class BlockwiseRepeatCommand
    implements Command {
        private final TextOperation command;
        private final int count;
        private final boolean doesInsert;
        private final boolean commitHistory;
        private final RegisterContent yankContent;

        public BlockwiseRepeatCommand(TextOperation command, int count, boolean doesInsert, boolean commitHistory, RegisterContent yankContent) {
            this.command = command;
            this.count = count;
            this.doesInsert = doesInsert;
            this.commitHistory = commitHistory;
            this.yankContent = yankContent;
        }

        @Override
        public Command repetition() {
            return this;
        }

        @Override
        public Command withCount(int count) {
            return this;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            boolean legal = true;
            RegisterManager registerManager = editorAdaptor.getRegisterManager();
            if (this.doesInsert) {
                Register lastEdit = registerManager.getLastEditRegister();
                RegisterContent content = lastEdit.getContent();
                if (!(content instanceof StringRegisterContent)) {
                    legal = false;
                } else {
                    StringRegisterContent stringInsert = (StringRegisterContent)content;
                    String string = stringInsert.getText();
                    if (VimUtils.containsNewLine(string)) {
                        legal = false;
                    } else {
                        Position newStart = editorAdaptor.getPosition().addModelOffset(-string.length() + 1);
                        editorAdaptor.setPosition(newStart, StickyColumnPolicy.NEVER);
                    }
                }
            }
            if (legal) {
                SelectionArea blockSelection = registerManager.getLastActiveSelectionArea();
                TextRange blockRange = blockSelection.getRegion(editorAdaptor, 0);
                BlockWiseSelection.TextBlock textBlock = BlockWiseSelection.getTextBlock(blockRange.getStart(), blockRange.getEnd(), editorAdaptor.getModelContent(), editorAdaptor.getCursorService());
                BlockwiseRepeatCommand.doIt(editorAdaptor, this.command, this.getCount(), textBlock);
                registerManager.getActiveRegister().setContent(this.yankContent);
            }
            if (this.commitHistory) {
                HistoryService history = editorAdaptor.getHistory();
                history.unlock("block-action");
                history.endCompoundChange();
            }
        }

        public static void doIt(EditorAdaptor editorAdaptor, TextOperation command, int count, BlockWiseSelection.TextBlock block) throws CommandExecutionException {
            RegisterManager registers = editorAdaptor.getRegisterManager();
            Register lastActiveRegister = registers.getActiveRegister();
            Register lastEditRegister = registers.getLastEditRegister();
            CursorService cursorService = editorAdaptor.getCursorService();
            TextContent textContent = editorAdaptor.getModelContent();
            TextOperation repetition = command.repetition();
            if (repetition == null) {
                repetition = command;
            }
            int endLine = Math.min(block.endLine, textContent.getNumberOfLines() - 1);
            int line = block.startLine + 1;
            while (line <= endLine) {
                Position runStart = cursorService.getPositionByVisualOffset(line, block.startVisualOffset);
                Position runEnd = cursorService.getPositionByVisualOffset(line, block.endVisualOffset);
                LineInformation lineInfo = textContent.getLineInformation(line);
                runEnd = runEnd == null || lineInfo.getLength() == 0 ? cursorService.newPositionForModelOffset(lineInfo.getEndOffset()) : runEnd.addModelOffset(1);
                if (runStart != null) {
                    editorAdaptor.setPosition(runStart, StickyColumnPolicy.NEVER);
                    DummyTextObject nextLine = new DummyTextObject(new StartEndTextRange(runStart, runEnd));
                    RegisterContent content = lastEditRegister.getContent();
                    try {
                        repetition.execute(editorAdaptor, count, nextLine);
                    }
                    finally {
                        registers.setActiveRegister(lastActiveRegister);
                    }
                    lastEditRegister.setContent(content);
                    if (repetition.repetition() != null) {
                        repetition = repetition.repetition();
                    }
                }
                ++line;
            }
            Position newPos = cursorService.getPositionByVisualOffset(block.startLine, block.startVisualOffset);
            if (newPos == null) {
                LineInformation lineInfo = textContent.getLineInformation(block.startLine);
                newPos = cursorService.newPositionForModelOffset(lineInfo.getEndOffset());
                if (lineInfo.getLength() > 0) {
                    newPos = newPos.addModelOffset(-1);
                }
            }
            editorAdaptor.setPosition(newPos, StickyColumnPolicy.ON_CHANGE);
        }
    }

    public static class DontChangeMode
    extends SelectionBasedTextOperationCommand {
        public DontChangeMode(TextOperation command) {
            super(command, false);
        }
    }

    public static class Repetition
    extends CountAwareCommand {
        private final TextOperation repetition;
        protected final boolean changeMode;

        public Repetition(TextOperation repeat, boolean changeMode) {
            this.repetition = repeat;
            this.changeMode = changeMode;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
            TextObject lastSelection = editorAdaptor.getLastActiveSelectionArea();
            try {
                if (lastSelection.getContentType(editorAdaptor.getConfiguration()) == ContentType.TEXT_RECTANGLE) {
                    TextContent modelContent = editorAdaptor.getModelContent();
                    TextRange region = lastSelection.getRegion(editorAdaptor, count);
                    SelectionBasedTextOperationCommand.doIt(editorAdaptor, count, this.repetition, modelContent, region, true);
                } else {
                    this.repetition.execute(editorAdaptor, count, lastSelection);
                }
            }
            finally {
                if (this.changeMode) {
                    LeaveVisualModeCommand.doIt(editorAdaptor);
                }
            }
        }

        @Override
        public CountAwareCommand repetition() {
            return this;
        }
    }
}

