/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.ArrayList;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class RetabOperation
extends AbstractLinewiseOperation {
    private static final String REPLACE_NORMAL_SPACE = "!";
    private static final String SPACE = " ";
    private boolean replaceNormalSpace = false;
    private Integer newTab = 0;

    public RetabOperation(String commandStr) {
        if (commandStr == null) {
            return;
        }
        if (commandStr.contains(REPLACE_NORMAL_SPACE)) {
            this.replaceNormalSpace = true;
            commandStr = commandStr.replace(REPLACE_NORMAL_SPACE, "");
        }
        if (commandStr.length() > 0) {
            try {
                this.newTab = Integer.parseInt(commandStr.trim());
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.entireFile(editorAdaptor);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        try {
            TextContent content = editorAdaptor.getModelContent();
            LineInformation startLine = content.getLineInformation(lineRange.getStartLine());
            LineInformation endLine = content.getLineInformation(lineRange.getEndLine());
            int length = lineRange.getModelLength();
            this.doIt(editorAdaptor, startLine, endLine, length);
        }
        catch (Exception e) {
            throw new CommandExecutionException("retab failed: " + e.getMessage());
        }
    }

    public void doIt(EditorAdaptor editorAdaptor, LineInformation startLine, LineInformation endLine, int totalLengthOfRange) throws Exception {
        int tabStop = editorAdaptor.getConfiguration().get(Options.TAB_STOP);
        boolean expandTab = editorAdaptor.getConfiguration().get(Options.EXPAND_TAB);
        if (tabStop == 0) {
            tabStop = 8;
        }
        Integer currenTabStop = editorAdaptor.getConfiguration().get(Options.TAB_STOP);
        if (this.newTab == 0) {
            this.newTab = currenTabStop;
        }
        String replacementSpaces = "";
        int i = 0;
        while (i < currenTabStop) {
            replacementSpaces = String.valueOf(replacementSpaces) + SPACE;
            ++i;
        }
        editorAdaptor.getConfiguration().set(Options.TAB_STOP, this.newTab);
        String newline = editorAdaptor.getConfiguration().getNewLine();
        TextContent content = editorAdaptor.getModelContent();
        int totalLinesInEditor = content.getNumberOfLines();
        ArrayList<String> editorContentList = new ArrayList<String>();
        LineInformation line = null;
        int i2 = startLine.getNumber();
        while (i2 <= endLine.getNumber()) {
            line = content.getLineInformation(i2);
            String lineStr = content.getText(line.getBeginOffset(), line.getLength());
            if (expandTab) {
                lineStr = lineStr.replaceAll("\\t", replacementSpaces);
            } else if (this.replaceNormalSpace) {
                lineStr = lineStr.replaceAll(replacementSpaces, "\t");
            }
            editorContentList.add(lineStr);
            ++i2;
        }
        StringBuilder replacementText = new StringBuilder();
        int count = startLine.getNumber();
        for (String editorLine : editorContentList) {
            if (count != totalLinesInEditor - 1) {
                editorLine = String.valueOf(editorLine) + newline;
            }
            ++count;
            replacementText.append(editorLine);
        }
        editorAdaptor.getModelContent().replace(startLine.getBeginOffset(), totalLengthOfRange, replacementText.toString());
        editorAdaptor.setPosition(editorAdaptor.getCursorService().newPositionForModelOffset(startLine.getBeginOffset()), StickyColumnPolicy.ON_CHANGE);
    }

    @Override
    public TextOperation repetition() {
        return null;
    }
}

