/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CommandWrappers;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.InsertLineCommand;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.register.Register;

class RepeatInsertAndEditLineCommand
extends CountAwareCommand {
    private Command firstLineInsertion;

    public RepeatInsertAndEditLineCommand(Command firstLineInsertion) {
        this.firstLineInsertion = firstLineInsertion;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        Register lastEditRegister = editorAdaptor.getRegisterManager().getLastEditRegister();
        if (count == 0) {
            count = 1;
        }
        InsertMode.createRepetition(lastEditRegister, this.firstLineInsertion, count, 0, 0).execute(editorAdaptor);
        if (count > 1) {
            InsertLineCommand insertLineCommand = InsertLineCommand.POST_CURSOR;
            CommandWrappers.repeat(count - 1, InsertMode.createRepetition(lastEditRegister, insertLineCommand, count, 0, 0)).execute(editorAdaptor);
        }
    }

    @Override
    public CountAwareCommand repetition() {
        return this;
    }
}

