/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.MacroRecorder;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class RecordMacroMode
extends AbstractMode {
    public static final Command TOGGLE_MACRO_RECORDING = new CountIgnoringNonRepeatableCommand(){

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            MacroRecorder recorder = editorAdaptor.getMacroRecorder();
            if (!recorder.isRecording()) {
                editorAdaptor.changeModeSafely(RecordMacroMode.NAME, new ModeSwitchHint[0]);
            } else {
                recorder.stopRecording();
            }
        }
    };
    public static final String NAME = "record macro mode";
    public static final char TOGGLE_KEY = 'q';

    public RecordMacroMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public void enterMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.enterMode(hints);
        UserInterfaceService uiService = this.editorAdaptor.getUserInterfaceService();
        uiService.setInfoSet(true);
        uiService.setLastCommandResultValue(String.valueOf('q'));
    }

    @Override
    public boolean handleKey(KeyStroke stroke) {
        if (VimConstants.PRINTABLE_KEYSTROKES.contains(stroke)) {
            this.editorAdaptor.getMacroRecorder().startRecording(String.valueOf(stroke.getCharacter()));
        }
        UserInterfaceService uiService = this.editorAdaptor.getUserInterfaceService();
        uiService.setInfoMessage("");
        uiService.setInfoSet(false);
        uiService.setLastCommandResultValue("");
        this.editorAdaptor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return "NORMAL";
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return null;
    }
}

