/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.SimpleRepeatableCommand;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.RegisterManager;

public class PlaybackMacroCommand
extends SimpleRepeatableCommand {
    public static final Function<Command, KeyStroke> KEYSTROKE_CONVERTER = new Function<Command, KeyStroke>(){

        @Override
        public Command call(KeyStroke arg) {
            return new PlaybackMacroCommand(arg.getCharacter());
        }
    };
    private final String macroName;

    public PlaybackMacroCommand(char macroName) {
        this(String.valueOf(macroName));
    }

    public PlaybackMacroCommand(String macroName) {
        this.macroName = macroName;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        RegisterManager registerManager = editorAdaptor.getRegisterManager();
        Register namedRegister = registerManager.getRegister(this.macroName);
        RegisterContent content = namedRegister.getContent();
        if (content == null) {
            throw new CommandExecutionException("Macro " + this.macroName + " does not exist");
        }
        registerManager.setLastNamedRegister(namedRegister);
        Iterable<KeyStroke> parsed = ConstructorWrappers.parseKeyStrokes(content.getText());
        editorAdaptor.getMacroPlayer(this.macroName).add(parsed);
    }

    @Override
    public Command repetition() {
        return this;
    }
}

