/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;

public class OptionDependentCommand<T>
implements Command {
    private final Configuration.Option<T> option;
    private final T triggerValue;
    private final Command wrapped;

    public OptionDependentCommand(Configuration.Option<T> option, T triggerValue, Command wrapped) {
        this.option = option;
        this.triggerValue = triggerValue;
        this.wrapped = wrapped;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        if (editorAdaptor.getConfiguration().get(this.option).equals(this.triggerValue)) {
            this.wrapped.execute(editorAdaptor);
        }
    }

    @Override
    public Command repetition() {
        return null;
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public Command withCount(int count) {
        return this;
    }

    public String toString() {
        return String.format("OptionDependentCommand(%s=%s, %s)", this.option, this.triggerValue, this.wrapped);
    }
}

