/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;

public class MultipleExecutionCommand
implements Command {
    private final int count;
    private final Command command;

    public MultipleExecutionCommand(int count, Command command) {
        if (count == 0) {
            count = 1;
        }
        this.count = count;
        this.command = command;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        HistoryService history = editorAdaptor.getHistory();
        try {
            history.beginCompoundChange();
            history.lock("multipleexecution");
            int i = 0;
            while (i < this.count) {
                this.command.execute(editorAdaptor);
                ++i;
            }
        }
        finally {
            history.unlock("multipleexecution");
            history.endCompoundChange();
        }
    }

    @Override
    public Command repetition() {
        Command repetition = (Command)this.command.repetition();
        if (repetition != null) {
            return new MultipleExecutionCommand(this.count, repetition);
        }
        return null;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Command withCount(int count) {
        return new MultipleExecutionCommand(count, this.command);
    }
}

