/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.Map;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractMessagesCommand;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.commandline.EvaluatorMapping;

public class ListUserCommandsCommand
extends AbstractMessagesCommand {
    private String name;

    public ListUserCommandsCommand() {
        this("");
    }

    public ListUserCommandsCommand(String name) {
        this.name = name;
    }

    @Override
    protected String getMessages(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        EvaluatorMapping maps = editorAdaptor.getPlatformSpecificStateProvider().getCommands();
        Map<String, String> userDefined = maps.getUserDefined();
        StringBuilder list = new StringBuilder();
        list.append(" Name        Definition\n");
        for (String command : userDefined.keySet()) {
            if (!command.startsWith(this.name)) continue;
            list.append(String.format(" %1$-11s %2$s\n", command, userDefined.get(command)));
        }
        return list.toString();
    }
}

