/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractMessagesCommand;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.register.RegisterManager;

public class ListRegistersCommand
extends AbstractMessagesCommand {
    private String toDisplay;

    public ListRegistersCommand() {
        this("");
    }

    public ListRegistersCommand(String toDisplay) {
        this.toDisplay = toDisplay;
    }

    @Override
    protected String getMessages(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        List<String> names;
        StringBuilder sb = new StringBuilder();
        RegisterManager registers = editorAdaptor.getRegisterManager();
        if (this.toDisplay.length() > 0) {
            this.toDisplay = this.toDisplay.replaceAll(" ", "");
            names = Arrays.asList(this.toDisplay.split("(?!^)"));
        } else {
            Set<String> allNames = registers.getRegisterNames();
            names = new ArrayList<String>(allNames);
        }
        Collections.sort(names);
        for (String name : names) {
            String reg = registers.getRegister(name).getContent().getText();
            reg = VimUtils.replaceNewLines(reg, "^J").trim();
            sb.append("\"").append(name).append("   ").append(reg).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isClipped() {
        return true;
    }
}

