/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.JoinLinesCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class JoinVisualLinesCommand
extends AbstractCommand {
    public static final Command INSTANCE = new JoinVisualLinesCommand(true);
    public static final Command DUMB_INSTANCE = new JoinVisualLinesCommand(false);
    private final boolean isSmart;

    private JoinVisualLinesCommand(boolean isSmart) {
        this.isSmart = isSmart;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        Selection selection = editorAdaptor.getSelection();
        Position from = selection.getLeftBound();
        Position to = selection.getRightBound();
        TextContent modelContent = editorAdaptor.getModelContent();
        int firstLineNo = modelContent.getLineInformationOfOffset(from.getModelOffset()).getNumber();
        int lastLineNo = modelContent.getLineInformationOfOffset(to.getModelOffset()).getNumber();
        try {
            editorAdaptor.getHistory().beginCompoundChange();
            editorAdaptor.changeMode("normal mode", new ModeSwitchHint[0]);
            editorAdaptor.setPosition(from, StickyColumnPolicy.NEVER);
            int length = 1 + lastLineNo - firstLineNo;
            if (ContentType.LINES.equals((Object)selection.getContentType(editorAdaptor.getConfiguration()))) {
                --length;
            }
            JoinLinesCommand.doIt(editorAdaptor, Math.max(2, length), this.isSmart);
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    @Override
    public Command repetition() {
        return this;
    }

    @Override
    public Command withCount(int count) {
        return this;
    }
}

