/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class JoinLinesCommand
extends CountAwareCommand {
    public static final Command INSTANCE = new JoinLinesCommand(true);
    public static final Command DUMB_INSTANCE = new JoinLinesCommand(false);
    private final boolean isSmart;

    private JoinLinesCommand(boolean isSmart) {
        this.isSmart = isSmart;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 2;
        }
        try {
            editorAdaptor.getHistory().beginCompoundChange();
            JoinLinesCommand.doIt(editorAdaptor, count, this.isSmart);
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    public static void doIt(EditorAdaptor editorAdaptor, int count, boolean isSmart) throws CommandExecutionException {
        if (count < 2) {
            count = 2;
        }
        TextContent modelContent = editorAdaptor.getModelContent();
        int i = 1;
        while (i < count) {
            String glue;
            int modelOffset = editorAdaptor.getPosition().getModelOffset();
            LineInformation firstLnInfo = modelContent.getLineInformationOfOffset(modelOffset);
            if (firstLnInfo.getNumber() + 1 == modelContent.getNumberOfLines()) {
                throw new CommandExecutionException("there is nothing to join below last line");
            }
            LineInformation secondLnInfo = modelContent.getLineInformation(firstLnInfo.getNumber() + 1);
            int eolOffset = firstLnInfo.getEndOffset();
            int bolOffset = secondLnInfo.getBeginOffset();
            String secondLineText = modelContent.getText(bolOffset, secondLnInfo.getLength());
            LineInformation lastLineInfo = modelContent.getLineInformation(modelContent.getNumberOfLines() - 1);
            if (isSmart) {
                glue = " ";
                if (firstLnInfo.getLength() == 0) {
                    glue = "";
                } else if (Character.isWhitespace(modelContent.getText(eolOffset - 1, 1).charAt(0))) {
                    glue = "";
                }
                int j = 0;
                while (j < secondLineText.length() && Character.isWhitespace(secondLineText.charAt(j))) {
                    ++bolOffset;
                    ++j;
                }
                if (secondLnInfo.getNumber() == lastLineInfo.getNumber() && secondLineText.length() == 0) {
                    glue = "";
                } else if (modelContent.getText(bolOffset, 1).charAt(0) == ')') {
                    glue = "";
                }
            } else {
                glue = "";
            }
            modelContent.replace(eolOffset, bolOffset - eolOffset, glue);
            editorAdaptor.setPosition(editorAdaptor.getCursorService().newPositionForModelOffset(eolOffset), StickyColumnPolicy.ON_CHANGE);
            ++i;
        }
    }

    @Override
    public CountAwareCommand repetition() {
        return this;
    }
}

