/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.InsertLineCommand;
import net.sourceforge.vrapper.vim.commands.RepeatInsertAndEditLineCommand;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.WithCountHint;

public class InsertAndEditLineCommand
extends CountAwareCommand {
    public static final Command PRE_CURSOR = new InsertAndEditLineCommand(InsertLineCommand.PRE_CURSOR);
    public static final Command POST_CURSOR = new InsertAndEditLineCommand(InsertLineCommand.POST_CURSOR);
    protected Command insertLine;

    public InsertAndEditLineCommand(Command insertLine) {
        this.insertLine = insertLine;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        editorAdaptor.changeModeSafely("insert mode", new WithCountHint(count), new ExecuteCommandHint.OnEnter(this.insertLine), new ExecuteCommandHint.OnRepeat(InsertLineCommand.POST_CURSOR));
    }

    @Override
    public CountAwareCommand repetition() {
        return new RepeatInsertAndEditLineCommand(this.insertLine);
    }
}

