/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class InsertAdjacentCharacter
extends CountIgnoringNonRepeatableCommand {
    public static final InsertAdjacentCharacter LINE_ABOVE = new InsertAdjacentCharacter(true);
    public static final InsertAdjacentCharacter LINE_BELOW = new InsertAdjacentCharacter(false);
    private boolean above;

    private InsertAdjacentCharacter(boolean above) {
        this.above = above;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        LineInformation adjacentLine;
        CursorService cursorService = editorAdaptor.getCursorService();
        TextContent content = editorAdaptor.getViewContent();
        Position cursor = cursorService.getPosition();
        int cursorOffset = cursor.getViewOffset();
        cursorService.setPosition(cursor, StickyColumnPolicy.RESET_EOL);
        int currentLineNumber = content.getLineInformationOfOffset(cursorOffset).getNumber();
        if (this.above && currentLineNumber > 0) {
            adjacentLine = content.getLineInformation(currentLineNumber - 1);
        } else if (!this.above && currentLineNumber < content.getNumberOfLines()) {
            adjacentLine = content.getLineInformation(currentLineNumber + 1);
        } else {
            return;
        }
        Position adjacentPos = cursorService.stickyColumnAtViewLine(adjacentLine.getNumber());
        int adjacentOffset = adjacentPos.getViewOffset();
        if (adjacentOffset < content.getTextLength() - 1) {
            String adjacentChar = content.getText(adjacentOffset, 1);
            if (VimUtils.isNewLine(adjacentChar)) {
                return;
            }
            content.smartInsert(adjacentChar);
            cursorService.setPosition(cursorService.newPositionForViewOffset(cursorOffset + 1), StickyColumnPolicy.ON_CHANGE);
        }
    }
}

