/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class InnerLineTextObject
implements TextObject {
    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        TextContent model = editorAdaptor.getModelContent();
        int modelOffset = editorAdaptor.getCursorService().getPosition().getModelOffset();
        LineInformation line = model.getLineInformationOfOffset(modelOffset);
        int startOffset = VimUtils.getFirstNonWhiteSpaceOffset(model, line);
        int endOffset = VimUtils.getLastNonWhiteSpaceOffset(model, line);
        if (endOffset < line.getEndOffset()) {
            ++endOffset;
        }
        Position left = editorAdaptor.getCursorService().newPositionForModelOffset(startOffset);
        Position right = editorAdaptor.getCursorService().newPositionForModelOffset(endOffset);
        return new StartEndTextRange(left, right);
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT;
    }

    @Override
    public TextObject withCount(int count) {
        return null;
    }

    @Override
    public int getCount() {
        return 0;
    }
}

