/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class FormatOperation
extends AbstractLinewiseOperation {
    public static final FormatOperation INSTANCE = new FormatOperation();

    @Override
    public TextOperation repetition() {
        return this;
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        TextRange originalTextRange = lineRange.getRegion(editorAdaptor, 0);
        String text = editorAdaptor.getModelContent().getText(originalTextRange);
        String newlineChar = editorAdaptor.getConfiguration().getNewLine();
        String[] lines = text.split(newlineChar);
        int textWidth = editorAdaptor.getConfiguration().get(Options.TEXT_WIDTH);
        int tabStop = editorAdaptor.getConfiguration().get(Options.TAB_STOP);
        CommentedLine previous = null;
        ArrayList<String> formattedLines = new ArrayList<String>();
        int i = 0;
        while (i < lines.length) {
            List<String> processed;
            CommentedLine current = new CommentedLine(lines[i]);
            if (!current.allowFormat()) {
                formattedLines.add(current.getFullLine());
                previous = null;
            } else if (previous != null && previous.getContinueChar().equals(current.getCommentChar())) {
                processed = this.formatLines(new ArrayList<String>(), new CommentedLine(previous.getPreIndent(), previous.getCommentChar(), previous.getPostIndent(), String.valueOf(previous.getText()) + " " + current.getText(), previous.getContinueChar()), textWidth, tabStop);
                formattedLines.remove(formattedLines.size() - 1);
                formattedLines.addAll(processed);
                previous = new CommentedLine(processed.get(processed.size() - 1));
            } else {
                processed = this.formatLines(new ArrayList<String>(), current, textWidth, tabStop);
                formattedLines.addAll(processed);
                previous = new CommentedLine(processed.get(processed.size() - 1));
            }
            ++i;
        }
        String newLines = "";
        for (String line : formattedLines) {
            newLines = String.valueOf(newLines) + line + newlineChar;
        }
        int start = originalTextRange.getLeftBound().getModelOffset();
        int length = originalTextRange.getModelLength();
        editorAdaptor.getModelContent().replace(start, length, newLines);
        editorAdaptor.getCursorService().setPosition(originalTextRange.getStart(), StickyColumnPolicy.ON_CHANGE);
    }

    private List<String> formatLines(List<String> formatted, CommentedLine textToFormat, int textWidth, int tabStop) {
        String fullLine = textToFormat.getFullLine();
        int[] visualOffsets = StringUtils.calculateVisualOffsets(fullLine, fullLine.length(), tabStop);
        if (visualOffsets[fullLine.length()] <= textWidth) {
            formatted.add(textToFormat.getFullLine());
        } else {
            String text = textToFormat.getText();
            int textStartIndex = textToFormat.getPrefix().length();
            int lineBreakIndex = this.findLineBreakIndex(text, textWidth, textStartIndex, visualOffsets);
            String line = text.substring(0, lineBreakIndex);
            String remainder = text.substring(lineBreakIndex).trim();
            formatted.add(String.valueOf(textToFormat.getPrefix()) + line);
            if (remainder.length() > 0) {
                CommentedLine newLine = new CommentedLine(textToFormat.getPreIndent(), textToFormat.getContinueChar(), textToFormat.getPostIndent(), remainder, textToFormat.getContinueChar());
                return this.formatLines(formatted, newLine, textWidth, tabStop);
            }
        }
        return formatted;
    }

    private int findLineBreakIndex(String text, int textwidth, int textStartIndex, int[] visualOffsets) {
        int lineBreakIndex = -1;
        int i = 0;
        while (i < text.length() && visualOffsets[i + textStartIndex] <= textwidth) {
            if (Character.isWhitespace(text.charAt(i))) {
                lineBreakIndex = i;
            }
            ++i;
        }
        if (lineBreakIndex == -1) {
            while (i < text.length() && !Character.isWhitespace(text.charAt(i))) {
                ++i;
            }
            if (i < text.length()) {
                lineBreakIndex = i;
            }
        }
        if (lineBreakIndex == -1) {
            lineBreakIndex = text.length();
        }
        return lineBreakIndex;
    }

    private class CommentedLine {
        public final List<String> SINGLE_LINE_COMMENTS = VimUtils.list("//!", "///", "//", "#", "*");
        public static final String MULTI_LINE_START = "/*";
        public static final String MULTI_LINE_END = "*/";
        private boolean allowFormat = true;
        private String fullLine = "";
        private String preIndent = "";
        private String commentChar = "";
        private String continueChar = "";
        private String postIndent = "";
        private String text = "";

        public boolean allowFormat() {
            return this.allowFormat;
        }

        public String getFullLine() {
            return this.fullLine;
        }

        public String getPreIndent() {
            return this.preIndent;
        }

        public String getCommentChar() {
            return this.commentChar;
        }

        public String getContinueChar() {
            return this.continueChar;
        }

        public String getPostIndent() {
            return this.postIndent;
        }

        public String getPrefix() {
            return String.valueOf(this.preIndent) + this.commentChar + this.postIndent;
        }

        public String getText() {
            return this.text;
        }

        public CommentedLine(String preIndent, String commentChar, String postIndent, String text, String continueChar) {
            this.preIndent = preIndent;
            this.commentChar = commentChar;
            this.postIndent = postIndent;
            this.text = text;
            this.continueChar = continueChar;
            this.fullLine = String.valueOf(preIndent) + commentChar + postIndent + text;
        }

        public CommentedLine(String line) {
            this.fullLine = line;
            int indentOffset = this.getFirstNonWhiteSpaceOffset(line);
            if (indentOffset > -1) {
                this.preIndent = line.substring(0, indentOffset);
                this.text = line.substring(indentOffset);
            } else {
                this.preIndent = "";
                this.text = line;
            }
            if (this.text.matches("\\s*") || this.text.startsWith(MULTI_LINE_END)) {
                this.allowFormat = false;
            } else if (this.text.startsWith(MULTI_LINE_START)) {
                this.commentChar = MULTI_LINE_START;
                this.continueChar = "*";
                this.text = this.text.substring(MULTI_LINE_START.length());
            } else {
                for (String comment : this.SINGLE_LINE_COMMENTS) {
                    if (!this.text.startsWith(comment)) continue;
                    this.commentChar = comment;
                    this.continueChar = comment;
                    this.text = this.text.substring(this.commentChar.length());
                    break;
                }
            }
            int postCommentOffset = this.getFirstNonWhiteSpaceOffset(this.text);
            if (postCommentOffset > -1) {
                this.postIndent = this.text.substring(0, postCommentOffset);
                this.text = this.text.substring(postCommentOffset);
            } else {
                this.allowFormat = false;
            }
        }

        private int getFirstNonWhiteSpaceOffset(String line) {
            int i = 0;
            while (i < line.length()) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

