/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;

public class FindFileCommand
extends CountIgnoringNonRepeatableCommand {
    public static final FindFileCommand INSTANCE = new FindFileCommand();
    private String filename;

    private FindFileCommand() {
        this.filename = null;
    }

    public FindFileCommand(String filename) {
        this.filename = filename.trim();
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        if (this.filename == null) {
            this.filename = VimUtils.getWordUnderCursor(editorAdaptor, true);
        }
        String[] paths = editorAdaptor.getConfiguration().get(Options.PATH).split(",");
        boolean success = editorAdaptor.getFileService().findAndOpenFile(this.filename, paths);
        if (!success) {
            editorAdaptor.getUserInterfaceService().setErrorMessage("Can't find file \"" + this.filename + "\" in path");
        }
        this.filename = null;
    }
}

