/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;

public class EditFileCommand
extends CountIgnoringNonRepeatableCommand {
    private String filename;

    public EditFileCommand(String filename) {
        this.filename = filename;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        if ("!".equals(this.filename)) {
            editorAdaptor.getFileService().revertFile();
            return;
        }
        if (!this.filename.startsWith("/")) {
            this.filename = editorAdaptor.getConfiguration().get(Options.AUTO_CHDIR) != false ? String.valueOf(editorAdaptor.getFileService().getCurrentFilePath()) + "/" + this.filename : String.valueOf(editorAdaptor.getRegisterManager().getCurrentWorkingDirectory()) + "/" + this.filename;
        }
        if (!editorAdaptor.getFileService().openFile(this.filename)) {
            if (editorAdaptor.getFileService().createFile(this.filename)) {
                if (editorAdaptor.getFileService().openFile(this.filename)) {
                    editorAdaptor.getUserInterfaceService().setInfoMessage("\"" + this.filename + "\" [New File]");
                } else {
                    editorAdaptor.getUserInterfaceService().setErrorMessage("Could not open file: " + this.filename);
                }
            } else {
                editorAdaptor.getUserInterfaceService().setErrorMessage("Could not open file: " + this.filename);
            }
        }
    }
}

